/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.UnresolvedUnionException;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.ipc.HandshakeMatch;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;
import org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Responder {
    private static final Logger LOG = LoggerFactory.getLogger(Responder.class);
    private static final Schema META = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.BYTES));
    private static final GenericDatumReader<Map<String, ByteBuffer>> META_READER = new GenericDatumReader(META);
    private static final GenericDatumWriter<Map<String, ByteBuffer>> META_WRITER = new GenericDatumWriter(META);
    private static final ThreadLocal<Protocol> REMOTE = new ThreadLocal();
    private final Map<MD5, Protocol> protocols = new ConcurrentHashMap<MD5, Protocol>();
    private final Protocol local;
    private final MD5 localHash;
    protected final List<RPCPlugin> rpcMetaPlugins;
    private SpecificDatumWriter<HandshakeResponse> handshakeWriter = new SpecificDatumWriter(HandshakeResponse.class);
    private SpecificDatumReader<HandshakeRequest> handshakeReader = new SpecificDatumReader(HandshakeRequest.class);

    protected Responder(Protocol local) {
        this.local = local;
        this.localHash = new MD5();
        this.localHash.bytes(local.getMD5());
        this.protocols.put(this.localHash, local);
        this.rpcMetaPlugins = new CopyOnWriteArrayList<RPCPlugin>();
    }

    public static Protocol getRemote() {
        return REMOTE.get();
    }

    public Protocol getLocal() {
        return this.local;
    }

    public void addRPCPlugin(RPCPlugin plugin) {
        this.rpcMetaPlugins.add(plugin);
    }

    public List<ByteBuffer> respond(List<ByteBuffer> buffers) throws IOException {
        return this.respond(buffers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ByteBuffer> respond(List<ByteBuffer> buffers, Transceiver connection) throws IOException {
        List handshake;
        List payload;
        RPCContext context;
        BinaryEncoder out;
        ByteBufferOutputStream bbo;
        block19: {
            BinaryDecoder in = DecoderFactory.get().binaryDecoder((InputStream)new ByteBufferInputStream(buffers), null);
            bbo = new ByteBufferOutputStream();
            out = EncoderFactory.get().binaryEncoder((OutputStream)bbo, null);
            Exception error = null;
            context = new RPCContext();
            payload = null;
            handshake = null;
            boolean wasConnected = connection != null && connection.isConnected();
            try {
                Protocol remote = this.handshake((Decoder)in, (Encoder)out, connection);
                out.flush();
                if (remote == null) {
                    return bbo.getBufferList();
                }
                handshake = bbo.getBufferList();
                context.setRequestCallMeta((Map)META_READER.read(null, (Decoder)in));
                String messageName = in.readString(null).toString();
                if (messageName.equals("")) {
                    return handshake;
                }
                Protocol.Message rm = (Protocol.Message)remote.getMessages().get(messageName);
                if (rm == null) {
                    throw new AvroRuntimeException("No such remote message: " + messageName);
                }
                Protocol.Message m = (Protocol.Message)this.getLocal().getMessages().get(messageName);
                if (m == null) {
                    throw new AvroRuntimeException("No message named " + messageName + " in " + String.valueOf(this.getLocal()));
                }
                Object request = this.readRequest(rm.getRequest(), m.getRequest(), (Decoder)in);
                context.setMessage(rm);
                for (RPCPlugin plugin : this.rpcMetaPlugins) {
                    plugin.serverReceiveRequest(context);
                }
                if (m.isOneWay() != rm.isOneWay() && wasConnected) {
                    throw new AvroRuntimeException("Not both one-way: " + messageName);
                }
                Object response = null;
                try {
                    REMOTE.set(remote);
                    response = this.respond(m, request);
                    context.setResponse(response);
                }
                catch (Exception e) {
                    error = e;
                    context.setError(error);
                    LOG.warn("user error", (Throwable)e);
                }
                finally {
                    REMOTE.set(null);
                }
                if (m.isOneWay() && wasConnected) {
                    return null;
                }
                out.writeBoolean(error != null);
                if (error == null) {
                    this.writeResponse(m.getResponse(), response, (Encoder)out);
                    break block19;
                }
                try {
                    this.writeError(m.getErrors(), error, (Encoder)out);
                }
                catch (UnresolvedUnionException e) {
                    throw error;
                }
            }
            catch (Exception e) {
                LOG.warn("system error", (Throwable)e);
                context.setError(e);
                bbo = new ByteBufferOutputStream();
                out = EncoderFactory.get().binaryEncoder((OutputStream)bbo, null);
                out.writeBoolean(true);
                this.writeError(Protocol.SYSTEM_ERRORS, new Utf8(e.toString()), (Encoder)out);
                if (null != handshake) break block19;
                handshake = new ByteBufferOutputStream().getBufferList();
            }
        }
        out.flush();
        payload = bbo.getBufferList();
        context.setResponsePayload(payload);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.serverSendResponse(context);
        }
        META_WRITER.write(context.responseCallMeta(), (Encoder)out);
        out.flush();
        bbo.prepend(handshake);
        bbo.append(payload);
        return bbo.getBufferList();
    }

    private Protocol handshake(Decoder in, Encoder out, Transceiver connection) throws IOException {
        if (connection != null && connection.isConnected()) {
            return connection.getRemote();
        }
        HandshakeRequest request = (HandshakeRequest)((Object)this.handshakeReader.read(null, in));
        Protocol remote = this.protocols.get((Object)request.getClientHash());
        if (remote == null && request.getClientProtocol() != null) {
            remote = Protocol.parse((String)request.getClientProtocol().toString());
            this.protocols.put(request.getClientHash(), remote);
        }
        HandshakeResponse response = new HandshakeResponse();
        if (this.localHash.equals((Object)request.getServerHash())) {
            response.setMatch(remote == null ? HandshakeMatch.NONE : HandshakeMatch.BOTH);
        } else {
            response.setMatch(remote == null ? HandshakeMatch.NONE : HandshakeMatch.CLIENT);
        }
        if (response.getMatch() != HandshakeMatch.BOTH) {
            response.setServerProtocol(this.local.toString());
            response.setServerHash(this.localHash);
        }
        RPCContext context = new RPCContext();
        context.setHandshakeRequest(request);
        context.setHandshakeResponse(response);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.serverConnecting(context);
        }
        this.handshakeWriter.write((Object)response, out);
        if (connection != null && response.getMatch() != HandshakeMatch.NONE) {
            connection.setRemote(remote);
        }
        return remote;
    }

    public abstract Object respond(Protocol.Message var1, Object var2) throws Exception;

    public abstract Object readRequest(Schema var1, Schema var2, Decoder var3) throws IOException;

    public abstract void writeResponse(Schema var1, Object var2, Encoder var3) throws IOException;

    public abstract void writeError(Schema var1, Object var2, Encoder var3) throws IOException;
}

