/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.Callback;

public abstract class Transceiver
implements Closeable {
    private final ReentrantLock channelLock = new ReentrantLock();

    public abstract String getRemoteName() throws IOException;

    public void lockChannel() {
        this.channelLock.lock();
    }

    public void unlockChannel() {
        if (this.channelLock.isHeldByCurrentThread()) {
            this.channelLock.unlock();
        }
    }

    public List<ByteBuffer> transceive(List<ByteBuffer> request) throws IOException {
        this.lockChannel();
        try {
            this.writeBuffers(request);
            List<ByteBuffer> list = this.readBuffers();
            return list;
        }
        finally {
            this.unlockChannel();
        }
    }

    public void transceive(List<ByteBuffer> request, Callback<List<ByteBuffer>> callback) throws IOException {
        try {
            List<ByteBuffer> response = this.transceive(request);
            callback.handleResult(response);
        }
        catch (IOException e) {
            callback.handleError(e);
        }
    }

    public abstract List<ByteBuffer> readBuffers() throws IOException;

    public abstract void writeBuffers(List<ByteBuffer> var1) throws IOException;

    public boolean isConnected() {
        return false;
    }

    public void setRemote(Protocol protocol) {
    }

    public Protocol getRemote() {
        throw new IllegalStateException("Not connected.");
    }

    @Override
    public void close() throws IOException {
    }
}

