/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryData;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.RawComparator;

class TetherKeyComparator
extends Configured
implements RawComparator<TetherData> {
    private Schema schema;

    TetherKeyComparator() {
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.schema = AvroJob.getMapOutputSchema(conf);
        }
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int diff = BinaryData.compare((byte[])b1, (int)BinaryData.skipLong((byte[])b1, (int)s1), (int)l1, (byte[])b2, (int)BinaryData.skipLong((byte[])b2, (int)s2), (int)l2, (Schema)this.schema);
        return diff == 0 ? -1 : diff;
    }

    public int compare(TetherData x, TetherData y) {
        ByteBuffer b1 = x.buffer();
        ByteBuffer b2 = y.buffer();
        int diff = BinaryData.compare((byte[])b1.array(), (int)b1.position(), (byte[])b2.array(), (int)b2.position(), (Schema)this.schema);
        return diff == 0 ? -1 : diff;
    }
}

