/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.tool.Tool;

public class SpecificCompilerTool
implements Tool {
    private static final FileExtensionFilter SCHEMA_FILTER = new FileExtensionFilter("avsc");
    private static final FileExtensionFilter PROTOCOL_FILTER = new FileExtensionFilter("avpr");

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> origArgs) throws Exception {
        if (origArgs.size() < 3) {
            System.err.println("Usage: [-encoding <outputencoding>] [-string] [-bigDecimal] [-fieldVisibility <visibilityType>] [-noSetters] [-nullSafeAnnotations] [-addExtraOptionalGetters] [-optionalGetters <optionalGettersType>] [-templateDir <templateDir>] (schema|protocol) input... outputdir");
            System.err.println(" input - input files or directories");
            System.err.println(" outputdir - directory to write generated java");
            System.err.println(" -encoding <outputencoding> - set the encoding of output file(s)");
            System.err.println(" -string - use java.lang.String instead of Utf8");
            System.err.println(" -fieldVisibility [private|public] - use either and default private");
            System.err.println(" -noSetters - do not generate setters");
            System.err.println(" -nullSafeAnnotations - add @Nullable and @NotNull annotations");
            System.err.println(" -addExtraOptionalGetters - generate extra getters with this format: 'getOptional<FieldName>'");
            System.err.println(" -optionalGetters [all_fields|only_nullable_fields]- generate getters returning Optional<T> for all fields or only for nullable fields");
            System.err.println(" -bigDecimal - use java.math.BigDecimal for decimal type instead of java.nio.ByteBuffer");
            System.err.println(" -templateDir - directory with custom Velocity templates");
            return 1;
        }
        CompilerOptions compilerOpts = new CompilerOptions();
        compilerOpts.stringType = GenericData.StringType.CharSequence;
        compilerOpts.useLogicalDecimal = false;
        compilerOpts.createSetters = true;
        compilerOpts.createNullSafeAnnotations = false;
        compilerOpts.optionalGettersType = Optional.empty();
        compilerOpts.addExtraOptionalGetters = false;
        compilerOpts.encoding = Optional.empty();
        compilerOpts.templateDir = Optional.empty();
        compilerOpts.fieldVisibility = Optional.empty();
        ArrayList<String> args = new ArrayList<String>(origArgs);
        if (args.contains("-noSetters")) {
            compilerOpts.createSetters = false;
            args.remove(args.indexOf("-noSetters"));
        }
        if (args.contains("-nullSafeAnnotations")) {
            compilerOpts.createNullSafeAnnotations = true;
            args.remove(args.indexOf("-nullSafeAnnotations"));
        }
        if (args.contains("-addExtraOptionalGetters")) {
            compilerOpts.addExtraOptionalGetters = true;
            args.remove(args.indexOf("-addExtraOptionalGetters"));
        }
        int arg = 0;
        if (args.contains("-optionalGetters")) {
            arg = args.indexOf("-optionalGetters") + 1;
            try {
                compilerOpts.optionalGettersType = Optional.of(OptionalGettersType.valueOf(((String)args.get(arg)).toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                System.err.println("Expected one of" + Arrays.toString((Object[])OptionalGettersType.values()));
                return 1;
            }
            args.remove(arg);
            args.remove(arg - 1);
        }
        if (args.contains("-encoding")) {
            arg = args.indexOf("-encoding") + 1;
            compilerOpts.encoding = Optional.of((String)args.get(arg));
            args.remove(arg);
            args.remove(arg - 1);
        }
        if (args.contains("-string")) {
            compilerOpts.stringType = GenericData.StringType.String;
            args.remove(args.indexOf("-string"));
        }
        if (args.contains("-fieldVisibility")) {
            arg = args.indexOf("-fieldVisibility") + 1;
            try {
                compilerOpts.fieldVisibility = Optional.of(SpecificCompiler.FieldVisibility.valueOf((String)((String)args.get(arg)).toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                System.err.println("Expected one of" + Arrays.toString(SpecificCompiler.FieldVisibility.values()));
                return 1;
            }
            args.remove(arg);
            args.remove(arg - 1);
        }
        if (args.contains("-templateDir")) {
            arg = args.indexOf("-templateDir") + 1;
            compilerOpts.templateDir = Optional.of((String)args.get(arg));
            args.remove(arg);
            args.remove(arg - 1);
        }
        if ("-bigDecimal".equalsIgnoreCase((String)args.get(arg = 0))) {
            compilerOpts.useLogicalDecimal = true;
            ++arg;
        }
        String method = (String)args.get(arg);
        ArrayList<File> inputs = new ArrayList<File>();
        File output = new File((String)args.get(args.size() - 1));
        for (int i = arg + 1; i < args.size() - 1; ++i) {
            inputs.add(new File((String)args.get(i)));
        }
        if ("schema".equals(method)) {
            Schema.Parser parser = new Schema.Parser();
            for (File src : SpecificCompilerTool.determineInputs(inputs, SCHEMA_FILTER)) {
                Schema schema = parser.parse(src);
                SpecificCompiler compiler = new SpecificCompiler(schema);
                this.executeCompiler(compiler, compilerOpts, src, output);
            }
        } else if ("protocol".equals(method)) {
            for (File src : SpecificCompilerTool.determineInputs(inputs, PROTOCOL_FILTER)) {
                Protocol protocol = Protocol.parse((File)src);
                SpecificCompiler compiler = new SpecificCompiler(protocol);
                this.executeCompiler(compiler, compilerOpts, src, output);
            }
        } else {
            System.err.println("Expected \"schema\" or \"protocol\".");
            return 1;
        }
        return 0;
    }

    private void executeCompiler(SpecificCompiler compiler, CompilerOptions opts, File src, File output) throws IOException {
        compiler.setStringType(opts.stringType);
        compiler.setCreateSetters(opts.createSetters);
        compiler.setCreateNullSafeAnnotations(opts.createNullSafeAnnotations);
        opts.optionalGettersType.ifPresent(choice -> {
            compiler.setGettersReturnOptional(true);
            switch (choice.ordinal()) {
                case 0: {
                    compiler.setOptionalGettersForNullableFieldsOnly(false);
                    break;
                }
                case 1: {
                    compiler.setOptionalGettersForNullableFieldsOnly(true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported value '" + String.valueOf(choice) + "'");
                }
            }
        });
        compiler.setCreateOptionalGetters(opts.addExtraOptionalGetters);
        opts.templateDir.ifPresent(arg_0 -> ((SpecificCompiler)compiler).setTemplateDir(arg_0));
        compiler.setEnableDecimalLogicalType(opts.useLogicalDecimal);
        opts.encoding.ifPresent(arg_0 -> ((SpecificCompiler)compiler).setOutputCharacterEncoding(arg_0));
        opts.fieldVisibility.ifPresent(arg_0 -> ((SpecificCompiler)compiler).setFieldVisibility(arg_0));
        compiler.compileToDestination(src, output);
    }

    @Override
    public String getName() {
        return "compile";
    }

    @Override
    public String getShortDescription() {
        return "Generates Java code for the given schema.";
    }

    private static File[] sortFiles(File[] files) {
        Objects.requireNonNull(files, "files cannot be null");
        Arrays.sort(files, Comparator.comparing(File::getName));
        return files;
    }

    private static File[] determineInputs(List<File> inputs, FilenameFilter filter) {
        LinkedHashSet<File> fileSet = new LinkedHashSet<File>();
        for (File file : inputs) {
            if (file.isDirectory()) {
                File[] files = file.listFiles(filter);
                Collections.addAll(fileSet, files != null ? SpecificCompilerTool.sortFiles(files) : new File[]{});
                continue;
            }
            fileSet.add(file);
        }
        if (fileSet.size() > 0) {
            System.err.println("Input files to compile:");
            for (File file : fileSet) {
                System.err.println("  " + String.valueOf(file));
            }
        } else {
            System.err.println("No input files found.");
        }
        return fileSet.toArray(new File[0]);
    }

    private static class CompilerOptions {
        Optional<String> encoding;
        GenericData.StringType stringType;
        Optional<SpecificCompiler.FieldVisibility> fieldVisibility;
        boolean useLogicalDecimal;
        boolean createSetters;
        boolean createNullSafeAnnotations;
        boolean addExtraOptionalGetters;
        Optional<OptionalGettersType> optionalGettersType;
        Optional<String> templateDir;

        private CompilerOptions() {
        }
    }

    private static enum OptionalGettersType {
        ALL_FIELDS,
        ONLY_NULLABLE_FIELDS;

    }

    private static class FileExtensionFilter
    implements FilenameFilter {
        private String extension;

        private FileExtensionFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

