/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.chain.impl.CatalogBase;
import org.apache.commons.chain.web.ChainResources;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChainListener
implements ServletContextListener {
    public static final String CONFIG_ATTR = "org.apache.commons.chain.CONFIG_ATTR";
    public static final String CONFIG_CLASS_RESOURCE = "org.apache.commons.chain.CONFIG_CLASS_RESOURCE";
    public static final String CONFIG_WEB_RESOURCE = "org.apache.commons.chain.CONFIG_WEB_RESOURCE";
    public static final String RULE_SET = "org.apache.commons.chain.RULE_SET";
    static /* synthetic */ Class class$org$apache$commons$chain$web$ChainListener;

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String attr = context.getInitParameter(CONFIG_ATTR);
        if (attr != null) {
            context.removeAttribute(attr);
        }
        CatalogFactory.clear();
    }

    public void contextInitialized(ServletContextEvent event) {
        Log log = LogFactory.getLog(class$org$apache$commons$chain$web$ChainListener == null ? (class$org$apache$commons$chain$web$ChainListener = ChainListener.class$("org.apache.commons.chain.web.ChainListener")) : class$org$apache$commons$chain$web$ChainListener);
        if (log.isInfoEnabled()) {
            log.info("Initializing chain listener");
        }
        ServletContext context = event.getServletContext();
        String attr = context.getInitParameter(CONFIG_ATTR);
        String classResources = context.getInitParameter(CONFIG_CLASS_RESOURCE);
        String ruleSet = context.getInitParameter(RULE_SET);
        String webResources = context.getInitParameter(CONFIG_WEB_RESOURCE);
        Catalog catalog = null;
        if (attr != null && (catalog = (Catalog)context.getAttribute(attr)) == null) {
            catalog = new CatalogBase();
        }
        ConfigParser parser = new ConfigParser();
        if (ruleSet != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                Class<?> clazz = loader.loadClass(ruleSet);
                parser.setRuleSet((RuleSet)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception initalizing RuleSet '" + ruleSet + "' instance: " + e.getMessage());
            }
        }
        if (attr == null) {
            this.parseJarResources(context, parser);
            ChainResources.parseClassResources(classResources, parser);
            ChainResources.parseWebResources(context, webResources, parser);
        } else {
            this.parseJarResources(catalog, context, parser);
            ChainResources.parseClassResources(catalog, classResources, parser);
            ChainResources.parseWebResources(catalog, context, webResources, parser);
        }
        if (attr != null) {
            context.setAttribute(attr, (Object)catalog);
        }
    }

    private void parseJarResources(ServletContext context, ConfigParser parser) {
        HashSet jars = context.getResourcePaths("/WEB-INF/lib");
        if (jars == null) {
            jars = new HashSet();
        }
        String path = null;
        Iterator paths = jars.iterator();
        while (paths.hasNext()) {
            path = (String)paths.next();
            if (!path.endsWith(".jar")) continue;
            URL resourceURL = null;
            try {
                URL jarURL = context.getResource(path);
                resourceURL = new URL("jar:" + this.translate(jarURL.toExternalForm()) + "!/META-INF/chain-config.xml");
                if (resourceURL == null) continue;
                InputStream is = null;
                try {
                    is = resourceURL.openStream();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (is == null) continue;
                is.close();
                parser.parse(resourceURL);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception parsing chain config resource '" + resourceURL.toExternalForm() + "': " + e.getMessage());
            }
        }
    }

    private void parseJarResources(Catalog catalog, ServletContext context, ConfigParser parser) {
        HashSet jars = context.getResourcePaths("/WEB-INF/lib");
        if (jars == null) {
            jars = new HashSet();
        }
        String path = null;
        Iterator paths = jars.iterator();
        while (paths.hasNext()) {
            path = (String)paths.next();
            if (!path.endsWith(".jar")) continue;
            URL resourceURL = null;
            try {
                URL jarURL = context.getResource(path);
                resourceURL = new URL("jar:" + this.translate(jarURL.toExternalForm()) + "!/META-INF/chain-config.xml");
                if (resourceURL == null) continue;
                InputStream is = null;
                try {
                    is = resourceURL.openStream();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (is == null) continue;
                is.close();
                parser.parse(catalog, resourceURL);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception parsing chain config resource '" + resourceURL.toExternalForm() + "': " + e.getMessage());
            }
        }
    }

    private String translate(String value) {
        int index;
        while ((index = value.indexOf(32)) >= 0) {
            value = value.substring(0, index) + value.substring(index + 1);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

