/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class DeleteSchemaElementAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TreeViewer viewer;

    public DeleteSchemaElementAction(TreeViewer viewer) {
        super(Messages.getString("DeleteSchemaElementAction.DeleteAction"));
        this.setToolTipText(Messages.getString("DeleteSchemaElementAction.DeleteToolTip"));
        this.setId(PluginConstants.CMD_DELETE_SCHEMA_ELEMENT);
        this.setActionDefinitionId(PluginConstants.CMD_DELETE_SCHEMA_ELEMENT);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/delete.gif"));
        this.setEnabled(true);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    boolean enabled = true;
                    for (Object selectedItem : selection) {
                        if (selectedItem instanceof SchemaWrapper || selectedItem instanceof AttributeTypeWrapper || selectedItem instanceof ObjectClassWrapper) continue;
                        enabled = false;
                        break;
                    }
                    DeleteSchemaElementAction.this.setEnabled(enabled);
                } else {
                    DeleteSchemaElementAction.this.setEnabled(false);
                }
            }
        });
    }

    public void run() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            StringBuilder message = new StringBuilder();
            int count = selection.size();
            if (count == 1) {
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof AttributeTypeWrapper) {
                    message.append(Messages.getString("DeleteSchemaElementAction.SureDeleteAttributeType"));
                } else if (firstElement instanceof ObjectClassWrapper) {
                    message.append(Messages.getString("DeleteSchemaElementAction.SureDeleteObjectClass"));
                } else if (firstElement instanceof SchemaWrapper) {
                    message.append(Messages.getString("DeleteSchemaElementAction.SureDeleteSchema"));
                } else {
                    message.append(Messages.getString("DeleteSchemaElementAction.SureDeleteItem"));
                }
            } else {
                message.append(NLS.bind((String)Messages.getString("DeleteSchemaElementAction.SureDeleteItems"), (Object[])new Object[]{count}));
            }
            if (MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("DeleteSchemaElementAction.DeleteTitle"), (String)message.toString())) {
                HashMap<String, Schema> schemasMap = new HashMap<String, Schema>();
                ArrayList<Object> schemaObjectsList = new ArrayList<Object>();
                for (Object e : selection) {
                    if (e instanceof SchemaWrapper) {
                        Schema schema = ((SchemaWrapper)e).getSchema();
                        schemasMap.put(Strings.toLowerCase((String)schema.getSchemaName()), schema);
                        continue;
                    }
                    if (e instanceof AttributeTypeWrapper) {
                        AttributeType at = ((AttributeTypeWrapper)e).getAttributeType();
                        schemaObjectsList.add(at);
                        continue;
                    }
                    if (!(e instanceof ObjectClassWrapper)) continue;
                    ObjectClass oc = ((ObjectClassWrapper)e).getObjectClass();
                    schemaObjectsList.add(oc);
                }
                SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
                for (SchemaObject schemaObject : schemaObjectsList) {
                    if (schemasMap.containsKey(Strings.toLowerCase((String)schemaObject.getSchemaName()))) continue;
                    if (schemaObject instanceof AttributeType) {
                        schemaHandler.removeAttributeType((AttributeType)schemaObject);
                        continue;
                    }
                    if (!(schemaObject instanceof ObjectClass)) continue;
                    schemaHandler.removeObjectClass((ObjectClass)schemaObject);
                }
                for (Schema schema : schemasMap.values()) {
                    schemaHandler.removeSchema(schema);
                }
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

