/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.api.util.IOUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.io.api.LdifSearchLogger;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportLogsToWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;

public class ExportSearchLogsWizard
extends ExportBaseWizard {
    private ExportLogsToWizardPage toPage;

    public ExportSearchLogsWizard() {
        super(Messages.getString("ExportSearchLogsWizard.ExportSearchLogs"));
    }

    public void addPages() {
        this.toPage = new ExportLogsToWizardPage(ExportLogsToWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.toPage);
    }

    public boolean performFinish() {
        this.toPage.saveDialogSettings();
        if (this.search.getBrowserConnection().getConnection() != null) {
            try {
                File targetFile = new File(this.exportFilename);
                OutputStream os = FileUtils.openOutputStream((File)targetFile);
                LdifSearchLogger searchLogger = ConnectionCorePlugin.getDefault().getLdifSearchLogger();
                File[] files = searchLogger.getFiles(this.search.getBrowserConnection().getConnection());
                int i = files.length - 1;
                while (i >= 0) {
                    File file = files[i];
                    if (file != null && file.exists() && file.canRead()) {
                        InputStream is = FileUtils.openInputStream((File)file);
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        is.close();
                    }
                    --i;
                }
                os.close();
            }
            catch (IOException e) {
                ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, BrowserCommonConstants.PLUGIN_ID, 4, Messages.getString("ExportSearchLogsWizard.CantExportSearchLogs"), (Throwable)e));
            }
        }
        return true;
    }
}

