/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline_embedded.internal;

import java.io.PrintStream;
import scala.tools.jline_embedded.internal.Preconditions;
import scala.tools.jline_embedded.internal.TestAccessible;

public final class Log {
    public static final boolean TRACE = Boolean.getBoolean(Log.class.getName() + ".trace");
    public static final boolean DEBUG = TRACE || Boolean.getBoolean(Log.class.getName() + ".debug");
    private static PrintStream output = System.err;

    public static PrintStream getOutput() {
        return output;
    }

    public static void setOutput(PrintStream out) {
        output = Preconditions.checkNotNull(out);
    }

    @TestAccessible
    static void render(PrintStream out, Object message) {
        if (message.getClass().isArray()) {
            Object[] array = (Object[])message;
            out.print("[");
            for (int i = 0; i < array.length; ++i) {
                out.print(array[i]);
                if (i + 1 >= array.length) continue;
                out.print(",");
            }
            out.print("]");
        } else {
            out.print(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestAccessible
    static void log(Level level, Object ... messages2) {
        PrintStream printStream = output;
        synchronized (printStream) {
            output.format("[%s] ", new Object[]{level});
            for (int i = 0; i < messages2.length; ++i) {
                if (i + 1 == messages2.length && messages2[i] instanceof Throwable) {
                    output.println();
                    ((Throwable)messages2[i]).printStackTrace(output);
                    continue;
                }
                Log.render(output, messages2[i]);
            }
            output.println();
            output.flush();
        }
    }

    public static void trace(Object ... messages2) {
        if (TRACE) {
            Log.log(Level.TRACE, messages2);
        }
    }

    public static void debug(Object ... messages2) {
        if (TRACE || DEBUG) {
            Log.log(Level.DEBUG, messages2);
        }
    }

    public static void info(Object ... messages2) {
        Log.log(Level.INFO, messages2);
    }

    public static void warn(Object ... messages2) {
        Log.log(Level.WARN, messages2);
    }

    public static void error(Object ... messages2) {
        Log.log(Level.ERROR, messages2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

