/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.kryo.kryo.serializers;

import org.apache.livy.shaded.kryo.kryo.Kryo;
import org.apache.livy.shaded.kryo.kryo.KryoException;
import org.apache.livy.shaded.kryo.kryo.Registration;
import org.apache.livy.shaded.kryo.kryo.Serializer;
import org.apache.livy.shaded.kryo.kryo.io.Input;
import org.apache.livy.shaded.kryo.kryo.io.Output;
import org.apache.livy.shaded.kryo.kryo.serializers.FieldSerializer;
import org.apache.livy.shaded.kryo.minlog.Log;
import org.apache.livy.shaded.kryo.reflectasm.FieldAccess;

class ObjectField
extends FieldSerializer.CachedField {
    public Class[] generics;
    final FieldSerializer fieldSerializer;
    final Class type;
    final Kryo kryo;

    ObjectField(FieldSerializer fieldSerializer) {
        this.fieldSerializer = fieldSerializer;
        this.kryo = fieldSerializer.kryo;
        this.type = fieldSerializer.type;
    }

    public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.field.get(object);
    }

    public void setField(Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(object, value);
    }

    public final void write(Output output, Object object) {
        try {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")" + " pos=" + output.position());
            }
            Object value = this.getField(object);
            Serializer serializer = this.serializer;
            if (this.valueClass == null) {
                if (value == null) {
                    this.kryo.writeClass(output, null);
                    return;
                }
                Registration registration = this.kryo.writeClass(output, value.getClass());
                if (serializer == null) {
                    serializer = registration.getSerializer();
                }
                serializer.setGenerics(this.kryo, this.generics);
                this.kryo.writeObject(output, value, serializer);
            } else {
                if (serializer == null) {
                    this.serializer = serializer = this.kryo.getSerializer(this.valueClass);
                }
                serializer.setGenerics(this.kryo, this.generics);
                if (this.canBeNull) {
                    this.kryo.writeObjectOrNull(output, value, serializer);
                } else {
                    if (value == null) {
                        throw new KryoException("Field value is null but canBeNull is false: " + this + " (" + object.getClass().getName() + ")");
                    }
                    this.kryo.writeObject(output, value, serializer);
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this + " (" + object.getClass().getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this + " (" + object.getClass().getName() + ")");
            throw ex;
        }
        catch (RuntimeException runtimeEx) {
            KryoException ex = new KryoException(runtimeEx);
            ex.addTrace(this + " (" + object.getClass().getName() + ")");
            throw ex;
        }
    }

    public final void read(Input input, Object object) {
        try {
            Object value;
            if (Log.TRACE) {
                Log.trace("kryo", "Read field: " + this + " (" + this.type.getName() + ")" + " pos=" + input.position());
            }
            Class concreteType = this.valueClass;
            Serializer serializer = this.serializer;
            if (concreteType == null) {
                Registration registration = this.kryo.readClass(input);
                if (registration == null) {
                    value = null;
                } else {
                    if (serializer == null) {
                        serializer = registration.getSerializer();
                    }
                    serializer.setGenerics(this.kryo, this.generics);
                    value = this.kryo.readObject(input, registration.getType(), serializer);
                }
            } else {
                if (serializer == null) {
                    this.serializer = serializer = this.kryo.getSerializer(this.valueClass);
                }
                serializer.setGenerics(this.kryo, this.generics);
                value = this.canBeNull ? this.kryo.readObjectOrNull(input, concreteType, serializer) : this.kryo.readObject(input, concreteType, serializer);
            }
            this.setField(object, value);
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this + " (" + this.type.getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this + " (" + this.type.getName() + ")");
            throw ex;
        }
        catch (RuntimeException runtimeEx) {
            KryoException ex = new KryoException(runtimeEx);
            ex.addTrace(this + " (" + this.type.getName() + ")");
            throw ex;
        }
    }

    public void copy(Object original, Object copy) {
        try {
            if (this.accessIndex != -1) {
                FieldAccess access = (FieldAccess)this.fieldSerializer.access;
                access.set(copy, this.accessIndex, this.kryo.copy(access.get(original, this.accessIndex)));
            } else {
                this.setField(copy, this.kryo.copy(this.getField(original)));
            }
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this + " (" + this.type.getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this + " (" + this.type.getName() + ")");
            throw ex;
        }
        catch (RuntimeException runtimeEx) {
            KryoException ex = new KryoException(runtimeEx);
            ex.addTrace(this + " (" + this.type.getName() + ")");
            throw ex;
        }
    }

    static final class ObjectDoubleField
    extends ObjectField {
        public ObjectDoubleField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getDouble(object);
        }
    }

    static final class ObjectLongField
    extends ObjectField {
        public ObjectLongField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getLong(object);
        }
    }

    static final class ObjectCharField
    extends ObjectField {
        public ObjectCharField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Character.valueOf(this.field.getChar(object));
        }
    }

    static final class ObjectBooleanField
    extends ObjectField {
        public ObjectBooleanField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getBoolean(object);
        }
    }

    static final class ObjectByteField
    extends ObjectField {
        public ObjectByteField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getByte(object);
        }
    }

    static final class ObjectShortField
    extends ObjectField {
        public ObjectShortField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getShort(object);
        }
    }

    static final class ObjectFloatField
    extends ObjectField {
        public ObjectFloatField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Float.valueOf(this.field.getFloat(object));
        }
    }

    static final class ObjectIntField
    extends ObjectField {
        public ObjectIntField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getInt(object);
        }
    }
}

