/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Properties;

public class Canonicalizer {
    public static final String NO_CODESOURCE = "n/c";
    private static final String CODEBASE_FILE_PREFIX = "file:";
    private static final String CODEBASE_URL_PREFIX = "url:";

    public final CodeSource propertize(CodeSource codeSource, Properties properties) {
        if (codeSource == null || codeSource.getLocation() == null) {
            return codeSource;
        }
        for (String string : properties.keySet()) {
            String property = (String)properties.get(string);
            String cs = codeSource.getLocation().toExternalForm();
            try {
                String value = CODEBASE_FILE_PREFIX + string;
                if (cs.startsWith(value)) {
                    URL url = new URL("file:${" + property + "}" + cs.substring(value.length()));
                    Certificate[] certs = codeSource.getCertificates();
                    return new CodeSource(url, certs);
                }
                value = CODEBASE_URL_PREFIX + string;
                if (!cs.startsWith(value)) continue;
                URL url = new URL("url:${" + property + "}" + cs.substring(value.length()));
                return new CodeSource(url, codeSource.getCertificates());
            }
            catch (MalformedURLException e) {
                break;
            }
        }
        return codeSource;
    }

    public final Permission propertize(Permission perm, Properties properties) {
        String target = perm.getName();
        if (perm instanceof FilePermission) {
            for (String string : properties.keySet()) {
                String property = (String)properties.get(string);
                String value = string;
                if (!target.startsWith(value)) continue;
                String newPath = "${" + property + "}" + target.substring(value.length());
                perm = new FilePermission(newPath, perm.getActions());
                break;
            }
        }
        return perm;
    }

    public static final String format(CodeSource codeSource) {
        if (codeSource == null || codeSource.getLocation() == null) {
            return NO_CODESOURCE;
        }
        String cs = codeSource.getLocation().toExternalForm();
        if (cs.endsWith(File.separator)) {
            cs = cs + "-";
        }
        return cs;
    }

    public static final String format(Principal[] principals) {
        return Canonicalizer.format(principals, false);
    }

    public static final String format(Principal[] principals, boolean forPolicy) {
        String out = "-";
        if (principals != null) {
            out = "";
            for (int i = 0; i < principals.length; ++i) {
                if (forPolicy) {
                    out = out + "  principal " + Canonicalizer.format(principals[i]);
                    if (i < principals.length - 1) {
                        out = out + ',';
                    }
                    out = out + "\n";
                    continue;
                }
                out = out + Canonicalizer.format(principals[i]);
                if (i >= principals.length - 1) continue;
                out = out + ' ';
            }
        }
        return out;
    }

    public static final Properties getPathSubstitutions() {
        final Properties substitutions = new Properties();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Enumeration<?> keys = System.getProperties().propertyNames();
                while (keys.hasMoreElements()) {
                    File file;
                    String path;
                    String substitutionProperty = (String)keys.nextElement();
                    if (substitutionProperty.equals("file.separator") || (path = System.getProperty(substitutionProperty)).length() <= 0 || !(file = new File(path)).exists()) continue;
                    try {
                        path = file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        System.err.println("Error de-referencing: " + e.getMessage());
                    }
                    substitutions.put(path, substitutionProperty);
                }
                return null;
            }
        });
        return substitutions;
    }

    public static final String format(Principal principal) {
        return principal.getClass().getName() + ' ' + '\"' + principal.getName() + '\"';
    }

    public static final String format(Permission permission) {
        boolean hasActions;
        String out = permission.getClass().getName() + " ";
        String target = permission.getName();
        String actions = permission.getActions();
        boolean hasName = target != null && target.length() != 0;
        boolean bl = hasActions = actions != null && actions.length() != 0;
        if (hasName) {
            String formattedTarget = target.replaceAll("\"", "\\u0022");
            out = out + "\"" + formattedTarget + "\"";
            if (hasActions) {
                out = out + ", ";
            }
        }
        if (hasActions) {
            out = out + "\"" + actions + "\"";
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public final CodeSource canonicalize(CodeSource codeSource, Properties properties) throws IOException {
        URL url = codeSource.getLocation();
        Certificate[] certs = codeSource.getCertificates();
        if (url != null) {
            String cs = url.getPath();
            if (cs.startsWith(CODEBASE_FILE_PREFIX)) {
                cs = cs.substring(5);
            } else if (cs.startsWith(CODEBASE_URL_PREFIX)) {
                return codeSource;
            }
            for (String string : properties.keySet()) {
                void var7_9;
                String property = (String)properties.get(string);
                String value = "${" + property + "}";
                if (!cs.startsWith(value)) continue;
                if (!string.endsWith(File.separator) && cs.length() <= value.length()) {
                    String string2 = string + File.separator;
                }
                cs = (String)var7_9 + cs.substring(value.length());
                break;
            }
            if (cs.contains("${") && cs.contains("}")) {
                return codeSource;
            }
            File file = new File(cs).getCanonicalFile();
            cs = file.getAbsolutePath();
            url = new URL(CODEBASE_FILE_PREFIX + cs);
        }
        return new CodeSource(url, certs);
    }

    public final Permission canonicalize(Permission permission) {
        if (permission instanceof FilePermission) {
            File file = new File(permission.getName());
            try {
                String canonicalName = file.getCanonicalPath();
                if (!permission.getName().equals(canonicalName)) {
                    String actions = permission.getActions();
                    permission = new FilePermission(canonicalName, actions);
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        } else if (permission instanceof SocketPermission) {
            String host = permission.getName();
            if (host.startsWith("localhost")) {
                return permission;
            }
            String port = null;
            String target = permission.getName();
            int lastColon = target.lastIndexOf(":");
            if (lastColon > -1) {
                host = target.substring(0, lastColon);
                port = target.substring(lastColon + 1, target.length());
            }
            final String testHost = host;
            String resolvedHost = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        InetAddress addr = InetAddress.getByName(testHost);
                        if (addr.isLoopbackAddress()) {
                            return "localhost";
                        }
                    }
                    catch (AccessControlException e) {
                        return testHost;
                    }
                    catch (UnknownHostException e) {
                        return testHost;
                    }
                    return testHost;
                }
            }, null);
            target = port == null ? resolvedHost : resolvedHost + ":" + port;
            String actions = permission.getActions();
            permission = new SocketPermission(target, actions);
        }
        return permission;
    }
}

