/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.viewController;

import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.viewController.ViewControllerExecutor;
import org.apache.myfaces.orchestra.viewController.ViewControllerManager;
import org.apache.myfaces.orchestra.viewController.ViewControllerNameMapper;

public abstract class AbstractViewControllerManager
implements ViewControllerManager {
    protected abstract ViewControllerNameMapper getViewControllerNameMapper();

    protected abstract ViewControllerExecutor getViewControllerExecutor();

    public String getViewControllerName(String viewId) {
        ViewControllerNameMapper nameMapper = this.getViewControllerNameMapper();
        return nameMapper.mapViewId(viewId);
    }

    public Object getViewController(String viewId) {
        String beanName = this.getViewControllerName(viewId);
        if (beanName == null) {
            return null;
        }
        return FrameworkAdapter.getCurrentInstance().getBean(beanName);
    }

    public void assertConversationState(String viewId) {
    }

    public void executeInitView(String viewId) {
        String beanName = this.getViewControllerNameMapper().mapViewId(viewId);
        Object viewController = this.getViewController(viewId);
        if (viewController != null) {
            this.getViewControllerExecutor().invokeInitView(beanName, viewController);
        }
    }

    public void executePreProcess(String viewId) {
        String beanName = this.getViewControllerNameMapper().mapViewId(viewId);
        Object viewController = this.getViewController(viewId);
        if (viewController != null) {
            this.getViewControllerExecutor().invokePreProcess(beanName, viewController);
        }
    }

    public void executePreRenderView(String viewId) {
        String beanName = this.getViewControllerNameMapper().mapViewId(viewId);
        Object viewController = this.getViewController(viewId);
        if (viewController != null) {
            this.getViewControllerExecutor().invokePreRenderView(beanName, viewController);
        }
    }
}

