/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.annotation;

import java.lang.reflect.Method;

import org.apache.myfaces.orchestra.conversation.annotations.ConversationName;
import org.apache.myfaces.orchestra.conversation.annotations.ConversationRequire;
import org.apache.myfaces.orchestra.viewController.annotations.ViewController;

/**
 * Holds information extracted out of a single bean using its annotations.
 */
public class AnnotationInfo
{
    private final String beanName;
    private final Class<?> beanClass;

    private ConversationName conversationName;
    private ConversationRequire conversationRequire;
    private ViewController viewController;

    // Method-level annotations for viewController callbacks
    private Method initViewMethod;
    private Method preProcessMethod;
    private Method preRenderViewMethod;

    public AnnotationInfo(String beanName, Class<?> beanClass)
    {
        this.beanName = beanName;
        this.beanClass = beanClass;
    }

    public String getBeanName()
    {
        return beanName;
    }

    public Class<?> getBeanClass()
    {
        return beanClass;
    }

    public ConversationName getConversationName()
    {
        return conversationName;
    }

    public void setConversationName(ConversationName conversationName)
    {
        this.conversationName = conversationName;
    }

    public ConversationRequire getConversationRequire()
    {
        return conversationRequire;
    }

    public void setConversationRequire(ConversationRequire conversationRequire)
    {
        this.conversationRequire = conversationRequire;
    }

    public ViewController getViewController()
    {
        return viewController;
    }

    public void setViewController(ViewController viewController)
    {
        this.viewController = viewController;
    }

    public Method getInitViewMethod()
    {
        return initViewMethod;
    }

    public void setInitViewMethod(Method initViewMethod)
    {
        this.initViewMethod = initViewMethod;
    }

    public Method getPreProcessMethod()
    {
        return preProcessMethod;
    }

    public void setPreProcessMethod(Method preProcessMethod)
    {
        this.preProcessMethod = preProcessMethod;
    }

    public Method getPreRenderViewMethod()
    {
        return preRenderViewMethod;
    }

    public void setPreRenderViewMethod(Method preRenderViewMethod)
    {
        this.preRenderViewMethod = preRenderViewMethod;
    }
}
