/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.connectionManager;

import java.sql.Connection;

/**
 * The interface for objects returned by the getConnection method of ConnectionManagerDataSource.
 * <p>
 * Implementations of this interface are expected to hold a reference to an underlying Connection. 
 */
public interface DisconnectableConnection extends Connection
{
    /**
     * Close the underlying connection object.
     * <p>
     * Note that if methods are called on this object that require a connection, then a 
     * fresh connection will transparently be allocated and cached.
     */
    public void disconnect();
    
    /**
     * Get the real underlying Connection object.
     * <p>
     * If this object is not currently connected, then null will be returned. Note that
     * a call to any proxied method that needs a connection will then allocate one.
     */
    public Connection getConnection();
}
