/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation;

/**
 * An object that is capable of creating a fully-configured instance of a
 * conversation context with a particular id.
 */
public class ConversationContextFactoryImpl implements  ConversationContextFactory
{
    // Default timeout for contexts: 30 minutes.
    public static final long DFLT_TIMEOUT_MINS = 30;

    private long timeoutMillis = DFLT_TIMEOUT_MINS * 60L * 1000L;

    public void setTimeoutSecs(long secs)
    {
        timeoutMillis = secs * 1000L;
    }

    public void setTimeoutMins(long mins)
    {
        timeoutMillis = mins * 60L * 1000L;
    }

    public ConversationContext createConversationContext(ConversationContext parent, long id)
    {
        ConversationContext ctx = new ConversationContext(parent, id);
        ctx.setTimeout(timeoutMillis);
        return ctx;
    }
}
