/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.jsf.components;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.orchestra.conversation.ConversationUtils;
import org.apache.myfaces.orchestra.conversation.jsf._JsfConversationUtils;
import org.apache.myfaces.orchestra.conversation.jsf.components.AbstractConversationComponent;
import org.apache.myfaces.orchestra.conversation.jsf.lib._EndConversationMethodBindingFacade;
import org.apache.myfaces.shared_orchestra.util.StringUtils;

public class UIEndConversation
extends AbstractConversationComponent {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.orchestra.EndConversation";
    private String onOutcome;
    private String errorOutcome;
    private boolean inited = false;

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        UICommand command = _JsfConversationUtils.findParentCommand((UIComponent)this);
        if (command != null) {
            if (!this.inited) {
                MethodBinding original = command.getAction();
                command.setAction((MethodBinding)new _EndConversationMethodBindingFacade(this.getName(), this.getOnOutcomes(), original, this.getErrorOutcome()));
                this.inited = true;
            }
        } else {
            ConversationUtils.invalidateIfExists(this.getName());
        }
    }

    private Collection getOnOutcomes() {
        String onOutcome = this.getOnOutcome();
        if (onOutcome == null || onOutcome.trim().length() < 1) {
            return null;
        }
        return Arrays.asList(StringUtils.trim(StringUtils.splitShortString(onOutcome, ',')));
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.inited = (Boolean)states[1];
        this.onOutcome = (String)states[2];
        this.errorOutcome = (String)states[3];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.inited ? Boolean.TRUE : Boolean.FALSE, this.onOutcome, this.errorOutcome};
    }

    public String getOnOutcome() {
        if (this.onOutcome != null) {
            return this.onOutcome;
        }
        ValueBinding vb = this.getValueBinding("onOutcome");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }

    public void setOnOutcome(String onOutcome) {
        this.onOutcome = onOutcome;
    }

    public String getErrorOutcome() {
        if (this.errorOutcome != null) {
            return this.errorOutcome;
        }
        ValueBinding vb = this.getValueBinding("errorOutcome");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }

    public void setErrorOutcome(String errorOutcome) {
        this.errorOutcome = errorOutcome;
    }
}

