/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation;

/**
 * Beans implementing this listener interface will get informed when
 * they are added to a conversation or removed from a conversation.
 * <p>
 * Note that when a conversation ends, the valueUnbound method is
 * invoked on each bean in the conversation.
 */
public interface ConversationBindingListener
{
    /**
     * The bean has been added to the conversation.
     */
    public void valueBound(ConversationBindingEvent event);

    /**
     * The bean has been removed from the conversation.
     */
    public void valueUnbound(ConversationBindingEvent event);
}
