/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.ScheduleService;
import org.apache.turbine.util.TurbineException;

public class SchedulerTool
implements ApplicationTool {
    private static Log log = LogFactory.getLog((String)"scheduler");
    @TurbineService
    private ScheduleService schedulerService;

    @Override
    public void init(Object data) {
        if (this.schedulerService == null) {
            log.error((Object)"You can not use the SchedulerTool unless you enable the Scheduler Service!!!!");
        }
    }

    @Override
    public void refresh() {
    }

    public List<? extends JobEntry> getScheduledJobs() {
        return this.schedulerService.listJobs();
    }

    public boolean isEnabled() {
        return this.schedulerService.isEnabled();
    }

    public JobEntry getJob(String jobId) {
        JobEntry je = null;
        try {
            je = this.schedulerService.getJob(Integer.parseInt(jobId));
        }
        catch (TurbineException e) {
            log.error((Object)("Could not retreive job id #" + jobId), (Throwable)e);
        }
        return je;
    }
}

