/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelTypeSystem;

public class LLUnambiguousIteratorImpl
implements LowLevelIterator {
    private final int[] annots;
    private int pos = 0;
    private final int size;
    private final LowLevelIterator theIterator;
    private final LowLevelCAS theCas;

    public LLUnambiguousIteratorImpl(LowLevelIterator it, LowLevelCAS cas) {
        this.theCas = cas;
        this.theIterator = it;
        this.annots = new int[it.ll_indexSize()];
        LowLevelTypeSystem ts = cas.ll_getTypeSystem();
        int annotType = ts.ll_getCodeForTypeName("uima.tcas.Annotation");
        int startFeat = ts.ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
        int endFeat = ts.ll_getCodeForFeatureName("uima.tcas.Annotation:end");
        int lastSeenEnd = 0;
        it.moveToFirst();
        int i = 0;
        while (it.isValid()) {
            int curRef = it.ll_get();
            int curType = cas.ll_getFSRefType(curRef);
            if (ts.ll_subsumes(annotType, curType) && (i == 0 || cas.ll_getIntValue(curRef, startFeat) >= lastSeenEnd)) {
                this.annots[i] = curRef;
                lastSeenEnd = cas.ll_getIntValue(curRef, endFeat);
                ++i;
            }
            it.moveToNext();
        }
        this.size = i;
    }

    @Override
    public void moveToFirst() {
        this.pos = 0;
    }

    @Override
    public void moveToLast() {
        this.pos = this.size - 1;
    }

    @Override
    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.size;
    }

    @Override
    public int ll_get() throws NoSuchElementException {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return this.annots[this.pos];
    }

    @Override
    public void moveToNext() {
        ++this.pos;
    }

    @Override
    public void moveToPrevious() {
        --this.pos;
    }

    @Override
    public void moveTo(int fsRef) {
        int position = this.binarySearch(this.annots, fsRef, 0, this.size);
        this.pos = position >= 0 ? position : -(position + 1);
    }

    @Override
    public Object copy() {
        LLUnambiguousIteratorImpl copy = new LLUnambiguousIteratorImpl(this.theIterator, this.theCas);
        copy.pos = this.pos;
        return copy;
    }

    @Override
    public int ll_indexSize() {
        return this.size;
    }

    @Override
    public LowLevelIndex ll_getIndex() {
        return this.theIterator.ll_getIndex();
    }

    private final int binarySearch(int[] array, int ele, int start, int end) {
        --end;
        while (start <= end) {
            int i = (int)(((long)start + (long)end) / 2L);
            int comp = this.ll_getIndex().ll_compare(ele, array[i]);
            if (comp == 0) {
                return i;
            }
            if (start == end) {
                if (comp < 0) {
                    return -i - 1;
                }
                return -i - 2;
            }
            if (comp < 0) {
                end = i - 1;
                continue;
            }
            start = i + 1;
        }
        return -start - 1;
    }
}

