/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap;

import java.net.MalformedURLException;
import java.util.Map;
import org.apache.uima.adapter.soap.AxisAnalysisEngineServiceStub;
import org.apache.uima.analysis_engine.service.impl.AnalysisEngineServiceAdapter;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;

public class SoapAnalysisEngineServiceAdapter
extends AnalysisEngineServiceAdapter {
    public boolean initialize(ResourceSpecifier aSpecifier, Map aAdditionalParams) throws ResourceInitializationException {
        if (!(aSpecifier instanceof URISpecifier)) {
            return false;
        }
        URISpecifier uriSpec = (URISpecifier)aSpecifier;
        if (!uriSpec.getProtocol().equals("SOAP") && !uriSpec.getProtocol().equals("SOAPwithAttachments")) {
            return false;
        }
        if (uriSpec.getResourceType() != null && !uriSpec.getResourceType().equals("AnalysisEngine")) {
            return false;
        }
        try {
            AxisAnalysisEngineServiceStub stub = new AxisAnalysisEngineServiceStub(uriSpec.getUri(), uriSpec.getTimeout(), uriSpec.getProtocol().equals("SOAPwithAttachments"));
            this.setStub(stub);
            super.initialize(aSpecifier, aAdditionalParams);
        }
        catch (MalformedURLException e) {
            throw new ResourceInitializationException("malformed_url", new Object[]{uriSpec.getUri(), uriSpec.getSourceUrlString()}, (Throwable)e);
        }
        if (this.getUimaContextAdmin().getSofaMap().size() > 0) {
            throw new ResourceInitializationException("sofa_mapping_not_supported_for_remote", new Object[]{this.getMetaData().getName()});
        }
        return true;
    }
}

