/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class BooleanExpression
extends BinaryExpression {
    public BooleanExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.typeCheck(staticContext, itemType);
        if (expression == this) {
            XPathException xPathException = TypeChecker.ebvError(this.operand0, staticContext.getConfiguration().getTypeHierarchy());
            if (xPathException != null) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            XPathException xPathException2 = TypeChecker.ebvError(this.operand1, staticContext.getConfiguration().getTypeHierarchy());
            if (xPathException2 != null) {
                xPathException2.setLocator(this);
                throw xPathException2;
            }
            if (this.operand0 instanceof Literal && !(((Literal)this.operand0).getValue() instanceof BooleanValue)) {
                this.operand0 = Literal.makeLiteral(BooleanValue.get(this.operand0.effectiveBooleanValue(null)));
            }
            if (this.operand1 instanceof Literal && !(((Literal)this.operand1).getValue() instanceof BooleanValue)) {
                this.operand1 = Literal.makeLiteral(BooleanValue.get(this.operand1.effectiveBooleanValue(null)));
            }
        }
        return expression;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (expression != this) {
            return expression;
        }
        if (this.operator == 10 && (Literal.isConstantBoolean(this.operand0, false) || Literal.isConstantBoolean(this.operand1, false))) {
            return new Literal(BooleanValue.FALSE);
        }
        if (this.operator == 9 && (Literal.isConstantBoolean(this.operand0, true) || Literal.isConstantBoolean(this.operand1, true))) {
            return new Literal(BooleanValue.TRUE);
        }
        if (expression == this && this.operator == 10 && this.operand1 instanceof UserFunctionCall && typeHierarchy.isSubType(this.operand1.getItemType(typeHierarchy), BuiltInAtomicType.BOOLEAN) && !this.containedInLoop(staticContext)) {
            IfExpression ifExpression = new IfExpression(this.operand0, this.operand1, Literal.makeLiteral(BooleanValue.FALSE));
            ifExpression.setLocationId(this.getLocationId());
            ifExpression.setParentExpression(this.getParentExpression());
            return ifExpression;
        }
        return this;
    }

    private boolean containedInLoop(StaticContext staticContext) {
        Expression expression = this;
        while (true) {
            Container container;
            if ((container = expression.getParentExpression()) instanceof Expression && ExpressionTool.isRepeatedSubexpression((Expression)container, expression, staticContext)) {
                return true;
            }
            if (!(container instanceof Expression)) break;
            expression = (Expression)container;
        }
        return false;
    }

    public Expression negate(StaticContext staticContext) {
        if (this.operator == 10) {
            BooleanFn booleanFn = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
            Expression[] expressionArray = new Expression[]{this.operand0};
            booleanFn.setArguments(expressionArray);
            BooleanFn booleanFn2 = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
            Expression[] expressionArray2 = new Expression[]{this.operand1};
            booleanFn2.setArguments(expressionArray2);
            return new BooleanExpression(booleanFn, 9, booleanFn2);
        }
        BooleanFn booleanFn = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
        Expression[] expressionArray = new Expression[]{this.operand0};
        booleanFn.setArguments(expressionArray);
        BooleanFn booleanFn3 = (BooleanFn)SystemFunction.makeSystemFunction("not", 1, staticContext.getNamePool());
        Expression[] expressionArray3 = new Expression[]{this.operand1};
        booleanFn3.setArguments(expressionArray3);
        return new BooleanExpression(booleanFn, 10, booleanFn3);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        switch (this.operator) {
            case 10: {
                return this.operand0.effectiveBooleanValue(xPathContext) && this.operand1.effectiveBooleanValue(xPathContext);
            }
            case 9: {
                return this.operand0.effectiveBooleanValue(xPathContext) || this.operand1.effectiveBooleanValue(xPathContext);
            }
        }
        throw new UnsupportedOperationException("Unknown operator in boolean expression");
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public static void listAndComponents(Expression expression, List list) {
        if (expression instanceof BooleanExpression && ((BooleanExpression)expression).getOperator() == 10) {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                BooleanExpression.listAndComponents((Expression)iterator.next(), list);
            }
        } else {
            list.add(expression);
        }
    }
}

