/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public abstract class Calculator
implements Serializable {
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TIMES = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int IDIV = 5;
    public static Calculator[] ANY_ANY = new Calculator[]{new AnyPlusAny(), new AnyMinusAny(), new AnyTimesAny(), new AnyDivAny(), new AnyModAny(), new AnyIdivAny()};
    public static Calculator[] DOUBLE_DOUBLE = new Calculator[]{new DoublePlusDouble(), new DoubleMinusDouble(), new DoubleTimesDouble(), new DoubleDivDouble(), new DoubleModDouble(), new DoubleIdivDouble()};
    public static Calculator[] DOUBLE_FLOAT = DOUBLE_DOUBLE;
    public static Calculator[] DOUBLE_DECIMAL = DOUBLE_DOUBLE;
    public static Calculator[] DOUBLE_INTEGER = DOUBLE_DOUBLE;
    public static Calculator[] FLOAT_DOUBLE = DOUBLE_DOUBLE;
    public static Calculator[] FLOAT_FLOAT = new Calculator[]{new FloatPlusFloat(), new FloatMinusFloat(), new FloatTimesFloat(), new FloatDivFloat(), new FloatModFloat(), new FloatIdivFloat()};
    public static Calculator[] FLOAT_DECIMAL = FLOAT_FLOAT;
    public static Calculator[] FLOAT_INTEGER = FLOAT_FLOAT;
    public static Calculator[] DECIMAL_DOUBLE = DOUBLE_DOUBLE;
    public static Calculator[] DECIMAL_FLOAT = FLOAT_FLOAT;
    public static Calculator[] DECIMAL_DECIMAL = new Calculator[]{new DecimalPlusDecimal(), new DecimalMinusDecimal(), new DecimalTimesDecimal(), new DecimalDivDecimal(), new DecimalModDecimal(), new DecimalIdivDecimal()};
    public static Calculator[] DECIMAL_INTEGER = DECIMAL_DECIMAL;
    public static Calculator[] INTEGER_DOUBLE = DOUBLE_DOUBLE;
    public static Calculator[] INTEGER_FLOAT = FLOAT_FLOAT;
    public static Calculator[] INTEGER_DECIMAL = DECIMAL_DECIMAL;
    public static Calculator[] INTEGER_INTEGER = new Calculator[]{new IntegerPlusInteger(), new IntegerMinusInteger(), new IntegerTimesInteger(), new IntegerDivInteger(), new IntegerModInteger(), new IntegerIdivInteger()};
    public static Calculator[] DATETIME_DATETIME = new Calculator[]{null, new DateTimeMinusDateTime(), null, null, null, null};
    public static Calculator[] DATETIME_DURATION = new Calculator[]{new DateTimePlusDuration(), new DateTimeMinusDuration(), null, null, null, null};
    public static Calculator[] DURATION_DATETIME = new Calculator[]{new DurationPlusDateTime(), null, null, null, null, null};
    public static Calculator[] DURATION_DURATION = new Calculator[]{new DurationPlusDuration(), new DurationMinusDuration(), null, new DurationDivDuration(), null, null};
    public static Calculator[] DURATION_NUMERIC = new Calculator[]{null, null, new DurationTimesNumeric(), new DurationDivNumeric(), null, null};
    public static Calculator[] NUMERIC_DURATION = new Calculator[]{null, null, new NumericTimesDuration(), null, null, null};
    private static IntHashMap table = new IntHashMap(100);
    private static IntHashMap nameTable = new IntHashMap(100);

    private static void def(int n, int n2, Calculator[] calculatorArray, String string) {
        int n3 = (n & 0xFFFF) << 16 | n2 & 0xFFFF;
        table.put(n3, calculatorArray);
        nameTable.put(n3, string);
        if (n == 518) {
            Calculator.def(634, n2, calculatorArray, string);
            Calculator.def(633, n2, calculatorArray, string);
        }
        if (n2 == 518) {
            Calculator.def(n, 634, calculatorArray, string);
            Calculator.def(n, 633, calculatorArray, string);
        }
        if (n == 519) {
            Calculator.def(521, n2, calculatorArray, string);
            Calculator.def(520, n2, calculatorArray, string);
        }
        if (n2 == 519) {
            Calculator.def(n, 521, calculatorArray, string);
            Calculator.def(n, 520, calculatorArray, string);
        }
        if (n == 517) {
            Calculator.def(631, n2, calculatorArray, string);
        }
        if (n2 == 517) {
            Calculator.def(n, 631, calculatorArray, string);
        }
    }

    public static Calculator getCalculator(int n, int n2, int n3, boolean bl) {
        int n4 = (n & 0xFFFF) << 16 | n2 & 0xFFFF;
        Calculator[] calculatorArray = (Calculator[])table.get(n4);
        if (calculatorArray == null) {
            if (bl) {
                return null;
            }
            return ANY_ANY[n3];
        }
        return calculatorArray[n3];
    }

    public static String getCalculatorSetName(int n, int n2) {
        int n3 = (n & 0xFFFF) << 16 | n2 & 0xFFFF;
        return (String)nameTable.get(n3);
    }

    public abstract AtomicValue compute(AtomicValue var1, AtomicValue var2, XPathContext var3) throws XPathException;

    public abstract AtomicType getResultType(AtomicType var1, AtomicType var2);

    static {
        Calculator.def(517, 517, DOUBLE_DOUBLE, "DOUBLE_DOUBLE");
        Calculator.def(517, 516, DOUBLE_FLOAT, "DOUBLE_FLOAT");
        Calculator.def(517, 515, DOUBLE_DECIMAL, "DOUBLE_DECIMAL");
        Calculator.def(517, 532, DOUBLE_INTEGER, "DOUBLE_INTEGER");
        Calculator.def(516, 517, FLOAT_DOUBLE, "FLOAT_DOUBLE");
        Calculator.def(516, 516, FLOAT_FLOAT, "FLOAT_FLOAT");
        Calculator.def(516, 515, FLOAT_DECIMAL, "FLOAT_DECIMAL");
        Calculator.def(516, 532, FLOAT_INTEGER, "FLOAT_INTEGER");
        Calculator.def(515, 517, DECIMAL_DOUBLE, "DECIMAL_DOUBLE");
        Calculator.def(515, 516, DECIMAL_FLOAT, "DECIMAL_FLOAT");
        Calculator.def(515, 515, DECIMAL_DECIMAL, "DECIMAL_DECIMAL");
        Calculator.def(515, 532, DECIMAL_INTEGER, "DECIMAL_INTEGER");
        Calculator.def(532, 517, INTEGER_DOUBLE, "INTEGER_DOUBLE");
        Calculator.def(532, 516, INTEGER_FLOAT, "INTEGER_FLOAT");
        Calculator.def(532, 515, INTEGER_DECIMAL, "INTEGER_DECIMAL");
        Calculator.def(532, 532, INTEGER_INTEGER, "INTEGER_INTEGER");
        Calculator.def(519, 519, DATETIME_DATETIME, "DATETIME_DATETIME");
        Calculator.def(519, 518, DATETIME_DURATION, "DATETIME_DURATION");
        Calculator.def(518, 519, DURATION_DATETIME, "DURATION_DATETIME");
        Calculator.def(518, 518, DURATION_DURATION, "DURATION_DURATION");
        Calculator.def(518, 517, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 516, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 515, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(518, 532, DURATION_NUMERIC, "DURATION_NUMERIC");
        Calculator.def(517, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(516, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(515, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
        Calculator.def(532, 518, NUMERIC_DURATION, "NUMERIC_DURATION");
    }

    private static class DurationDivNumeric
    extends Calculator {
        private DurationDivNumeric() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            double d = 1.0 / ((NumericValue)atomicValue2).getDoubleValue();
            return ((DurationValue)atomicValue).multiply(d);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }
    }

    private static class NumericTimesDuration
    extends Calculator {
        private NumericTimesDuration() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((DurationValue)atomicValue2).multiply(((NumericValue)atomicValue).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType2;
        }
    }

    private static class DurationTimesNumeric
    extends Calculator {
        private DurationTimesNumeric() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((DurationValue)atomicValue).multiply(((NumericValue)atomicValue2).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }
    }

    private static class DurationDivDuration
    extends Calculator {
        private DurationDivDuration() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((DurationValue)atomicValue).divide((DurationValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DurationMinusDuration
    extends Calculator {
        private DurationMinusDuration() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((DurationValue)atomicValue).subtract((DurationValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }
    }

    private static class DurationPlusDuration
    extends Calculator {
        private DurationPlusDuration() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((DurationValue)atomicValue).add((DurationValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }
    }

    private static class DurationPlusDateTime
    extends Calculator {
        private DurationPlusDateTime() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((CalendarValue)atomicValue2).add((DurationValue)atomicValue);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType2;
        }
    }

    private static class DateTimeMinusDuration
    extends Calculator {
        private DateTimeMinusDuration() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((CalendarValue)atomicValue).add(((DurationValue)atomicValue2).multiply(-1.0));
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }
    }

    private static class DateTimePlusDuration
    extends Calculator {
        private DateTimePlusDuration() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((CalendarValue)atomicValue).add((DurationValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return atomicType;
        }
    }

    private static class DateTimeMinusDateTime
    extends Calculator {
        private DateTimeMinusDateTime() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((CalendarValue)atomicValue).subtract((CalendarValue)atomicValue2, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DAY_TIME_DURATION;
        }
    }

    private static class IntegerIdivInteger
    extends Calculator {
        private IntegerIdivInteger() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((IntegerValue)atomicValue).idiv((IntegerValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerModInteger
    extends Calculator {
        private IntegerModInteger() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((IntegerValue)atomicValue).mod((IntegerValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerDivInteger
    extends Calculator {
        private IntegerDivInteger() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((IntegerValue)atomicValue).div((IntegerValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class IntegerTimesInteger
    extends Calculator {
        private IntegerTimesInteger() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((IntegerValue)atomicValue).times((IntegerValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerMinusInteger
    extends Calculator {
        private IntegerMinusInteger() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((IntegerValue)atomicValue).minus((IntegerValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class IntegerPlusInteger
    extends Calculator {
        private IntegerPlusInteger() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return ((IntegerValue)atomicValue).plus((IntegerValue)atomicValue2);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class DecimalIdivDecimal
    extends Calculator {
        private DecimalIdivDecimal() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).idiv((IntegerValue)atomicValue2);
            }
            BigDecimal bigDecimal = ((NumericValue)atomicValue).getDecimalValue();
            BigDecimal bigDecimal2 = ((NumericValue)atomicValue2).getDecimalValue();
            if (bigDecimal2.signum() == 0) {
                throw new DynamicError("Integer division by zero", "FOAR0001", xPathContext);
            }
            BigInteger bigInteger = bigDecimal.divide(bigDecimal2, 0, 1).toBigInteger();
            return BigIntegerValue.makeIntegerValue(bigInteger);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class DecimalModDecimal
    extends Calculator {
        private DecimalModDecimal() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).mod((IntegerValue)atomicValue2);
            }
            BigDecimal bigDecimal = ((NumericValue)atomicValue).getDecimalValue();
            BigDecimal bigDecimal2 = ((NumericValue)atomicValue2).getDecimalValue();
            try {
                BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 0, 1);
                BigDecimal bigDecimal4 = bigDecimal.subtract(bigDecimal3.multiply(bigDecimal2));
                return new DecimalValue(bigDecimal4);
            }
            catch (ArithmeticException arithmeticException) {
                if (((NumericValue)atomicValue2).compareTo(0L) == 0) {
                    throw new DynamicError("Decimal modulo zero", "FOAR0001", xPathContext);
                }
                throw arithmeticException;
            }
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalDivDecimal
    extends Calculator {
        private DecimalDivDecimal() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            BigDecimal bigDecimal = ((NumericValue)atomicValue).getDecimalValue();
            BigDecimal bigDecimal2 = ((NumericValue)atomicValue2).getDecimalValue();
            int n = Math.max(18, Math.max(bigDecimal.scale(), bigDecimal2.scale()));
            try {
                BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, n, 5);
                return new DecimalValue(bigDecimal3);
            }
            catch (ArithmeticException arithmeticException) {
                if (((NumericValue)atomicValue2).compareTo(0L) == 0) {
                    throw new DynamicError("Decimal divide by zero", "FOAR0001", xPathContext);
                }
                throw arithmeticException;
            }
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalTimesDecimal
    extends Calculator {
        private DecimalTimesDecimal() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).times((IntegerValue)atomicValue2);
            }
            return new DecimalValue(((NumericValue)atomicValue).getDecimalValue().multiply(((NumericValue)atomicValue2).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalMinusDecimal
    extends Calculator {
        private DecimalMinusDecimal() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).minus((IntegerValue)atomicValue2);
            }
            return new DecimalValue(((NumericValue)atomicValue).getDecimalValue().subtract(((NumericValue)atomicValue2).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class DecimalPlusDecimal
    extends Calculator {
        private DecimalPlusDecimal() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            if (atomicValue instanceof IntegerValue && atomicValue2 instanceof IntegerValue) {
                return ((IntegerValue)atomicValue).plus((IntegerValue)atomicValue2);
            }
            return new DecimalValue(((NumericValue)atomicValue).getDecimalValue().add(((NumericValue)atomicValue2).getDecimalValue()));
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    private static class FloatIdivFloat
    extends Calculator {
        private FloatIdivFloat() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            float f = ((NumericValue)atomicValue).getFloatValue();
            float f2 = ((NumericValue)atomicValue2).getFloatValue();
            if ((double)f2 == 0.0) {
                throw new DynamicError("Integer division by zero", "FOAR0001", xPathContext);
            }
            if (Double.isNaN(f) || Double.isInfinite(f)) {
                throw new DynamicError("First operand of idiv is NaN or infinity", "FOAR0002", xPathContext);
            }
            if (Double.isNaN(f2)) {
                throw new DynamicError("Second operand of idiv is NaN", "FOAR0002", xPathContext);
            }
            return new FloatValue(f / f2).convert(BuiltInAtomicType.INTEGER, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class FloatModFloat
    extends Calculator {
        private FloatModFloat() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() % ((NumericValue)atomicValue2).getFloatValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatDivFloat
    extends Calculator {
        private FloatDivFloat() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() / ((NumericValue)atomicValue2).getFloatValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatTimesFloat
    extends Calculator {
        private FloatTimesFloat() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() * ((NumericValue)atomicValue2).getFloatValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatMinusFloat
    extends Calculator {
        private FloatMinusFloat() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() - ((NumericValue)atomicValue2).getFloatValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class FloatPlusFloat
    extends Calculator {
        private FloatPlusFloat() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new FloatValue(((NumericValue)atomicValue).getFloatValue() + ((NumericValue)atomicValue2).getFloatValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.FLOAT;
        }
    }

    private static class DoubleIdivDouble
    extends Calculator {
        private DoubleIdivDouble() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            double d = ((NumericValue)atomicValue).getDoubleValue();
            double d2 = ((NumericValue)atomicValue2).getDoubleValue();
            if (d2 == 0.0) {
                throw new DynamicError("Integer division by zero", "FOAR0001", xPathContext);
            }
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new DynamicError("First operand of idiv is NaN or infinity", "FOAR0002", xPathContext);
            }
            if (Double.isNaN(d2)) {
                throw new DynamicError("Second operand of idiv is NaN", "FOAR0002", xPathContext);
            }
            return new DoubleValue(d / d2).convert(BuiltInAtomicType.INTEGER, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.INTEGER;
        }
    }

    private static class DoubleModDouble
    extends Calculator {
        private DoubleModDouble() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() % ((NumericValue)atomicValue2).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleDivDouble
    extends Calculator {
        private DoubleDivDouble() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() / ((NumericValue)atomicValue2).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleTimesDouble
    extends Calculator {
        private DoubleTimesDouble() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() * ((NumericValue)atomicValue2).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoubleMinusDouble
    extends Calculator {
        private DoubleMinusDouble() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() - ((NumericValue)atomicValue2).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class DoublePlusDouble
    extends Calculator {
        private DoublePlusDouble() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            return new DoubleValue(((NumericValue)atomicValue).getDoubleValue() + ((NumericValue)atomicValue2).getDoubleValue());
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    private static class AnyIdivAny
    extends Calculator {
        private AnyIdivAny() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            Calculator calculator = AnyIdivAny.getCalculator(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), 5, true);
            if (calculator == null) {
                throw new DynamicError("Unsuitable types for idiv operation", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyModAny
    extends Calculator {
        private AnyModAny() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            Calculator calculator = AnyModAny.getCalculator(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), 4, true);
            if (calculator == null) {
                throw new DynamicError("Unsuitable types for mod operation", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyDivAny
    extends Calculator {
        private AnyDivAny() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            Calculator calculator = AnyDivAny.getCalculator(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), 3, true);
            if (calculator == null) {
                throw new DynamicError("Unsuitable types for div operation", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyTimesAny
    extends Calculator {
        private AnyTimesAny() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            Calculator calculator = AnyTimesAny.getCalculator(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), 2, true);
            if (calculator == null) {
                throw new DynamicError("Unsuitable types for * operation", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyMinusAny
    extends Calculator {
        private AnyMinusAny() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            Calculator calculator = AnyMinusAny.getCalculator(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), 1, true);
            if (calculator == null) {
                throw new DynamicError("Unsuitable types for - operation (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ")", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }

    private static class AnyPlusAny
    extends Calculator {
        private AnyPlusAny() {
        }

        public AtomicValue compute(AtomicValue atomicValue, AtomicValue atomicValue2, XPathContext xPathContext) throws XPathException {
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            Calculator calculator = AnyPlusAny.getCalculator(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), 0, true);
            if (calculator == null) {
                throw new DynamicError("Unsuitable types for + operation", "XPTY0004", xPathContext);
            }
            return calculator.compute(atomicValue, atomicValue2, xPathContext);
        }

        public AtomicType getResultType(AtomicType atomicType, AtomicType atomicType2) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
    }
}

