/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleMappingExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.sort.Reverser;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public final class PathExpression
extends Expression
implements ContextMappingFunction {
    private Expression start;
    private Expression step;
    private transient int state = 0;

    public PathExpression(Expression expression, Expression expression2) {
        this.start = expression;
        this.step = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
        if (expression2 instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expression2;
            if (PathExpression.isFilteredAxisPath(pathExpression.start) && PathExpression.isFilteredAxisPath(pathExpression.step)) {
                this.start = new PathExpression(expression, pathExpression.start);
                ExpressionTool.copyLocationInfo(expression, this.start);
                this.step = pathExpression.step;
                this.resetStaticProperties();
            }
        }
    }

    public Expression getStartExpression() {
        return this.start;
    }

    public Expression getStepExpression() {
        return this.step;
    }

    private static boolean isFilteredAxisPath(Expression expression) {
        if (expression instanceof AxisExpression) {
            return true;
        }
        while (expression instanceof FilterExpression) {
            expression = ((FilterExpression)expression).getBaseExpression();
        }
        return expression instanceof AxisExpression;
    }

    public final ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.step.getItemType(typeHierarchy);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.state > 0) {
            return this;
        }
        this.state = 1;
        this.start = this.start.simplify(staticContext);
        this.step = this.step.simplify(staticContext);
        this.resetStaticProperties();
        if (Literal.isEmptySequence(this.start)) {
            return this.start;
        }
        if (Literal.isEmptySequence(this.step)) {
            return this.step;
        }
        if (this.start instanceof ContextItemExpression && (this.step instanceof PathExpression || (this.step.getSpecialProperties() & 0x20000) != 0)) {
            this.step.setLocationId(this.getLocationId());
            this.step.setParentExpression(this.getParentExpression());
            return this.step;
        }
        if (this.step instanceof ContextItemExpression && (this.start instanceof PathExpression || (this.start.getSpecialProperties() & 0x20000) != 0)) {
            this.start.setLocationId(this.getLocationId());
            this.start.setParentExpression(this.getParentExpression());
            return this.start;
        }
        if (this.step instanceof PathExpression && ((PathExpression)this.step).getFirstStep() instanceof ContextItemExpression) {
            PathExpression pathExpression = new PathExpression(this.start, ((PathExpression)this.step).getRemainingSteps());
            pathExpression.setLocationId(this.getLocationId());
            pathExpression.setParentExpression(this.getParentExpression());
            return pathExpression;
        }
        if (this.start instanceof PathExpression && ((PathExpression)this.start).getLastStep() instanceof ContextItemExpression) {
            PathExpression pathExpression = new PathExpression(((PathExpression)this.start).getLeadingSteps(), this.step);
            pathExpression.setLocationId(this.getLocationId());
            pathExpression.setParentExpression(this.getParentExpression());
            return pathExpression;
        }
        if (this.start instanceof RootExpression && this.step instanceof ParentNodeExpression) {
            return Literal.makeLiteral(EmptySequence.getInstance());
        }
        return this;
    }

    private PathExpression simplifyDescendantPath(StaticContext staticContext) {
        Expression expression;
        Expression expression2;
        Expression expression3 = this.start;
        if (this.start instanceof AxisExpression) {
            expression2 = (AxisExpression)this.start;
            if (expression2.getAxis() != 5) {
                return null;
            }
            expression = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, expression);
            expression3 = new PathExpression(expression, expression2);
            ExpressionTool.copyLocationInfo(this, expression3);
        }
        if (!(expression3 instanceof PathExpression)) {
            return null;
        }
        expression2 = (PathExpression)expression3;
        if (!(((PathExpression)expression2).step instanceof AxisExpression)) {
            return null;
        }
        expression = (AxisExpression)((PathExpression)expression2).step;
        if (((AxisExpression)expression).getAxis() != 5) {
            return null;
        }
        NodeTest nodeTest = ((AxisExpression)expression).getNodeTest();
        if (nodeTest != null && !(nodeTest instanceof AnyNodeTest)) {
            return null;
        }
        Expression expression4 = this.step;
        while (expression4 instanceof FilterExpression) {
            if (((FilterExpression)expression4).isPositional(staticContext.getConfiguration().getTypeHierarchy())) {
                return null;
            }
            expression4 = ((FilterExpression)expression4).getBaseExpression();
        }
        if (!(expression4 instanceof AxisExpression)) {
            return null;
        }
        AxisExpression axisExpression = (AxisExpression)expression4;
        if (axisExpression.getAxis() == 3) {
            Expression expression5 = new AxisExpression(4, ((AxisExpression)expression4).getNodeTest());
            ExpressionTool.copyLocationInfo(this, expression5);
            expression4 = this.step;
            while (expression4 instanceof FilterExpression) {
                expression5 = new FilterExpression(expression5, ((FilterExpression)expression4).getFilter());
                ExpressionTool.copyLocationInfo(expression4, expression5);
                expression4 = ((FilterExpression)expression4).getBaseExpression();
            }
            PathExpression pathExpression = new PathExpression(((PathExpression)expression2).start, expression5);
            ExpressionTool.copyLocationInfo(this, pathExpression);
            return pathExpression;
        }
        if (axisExpression.getAxis() == 2) {
            AxisExpression axisExpression2 = new AxisExpression(5, NodeKindTest.ELEMENT);
            ExpressionTool.copyLocationInfo(this, axisExpression2);
            PathExpression pathExpression = new PathExpression(new PathExpression(((PathExpression)expression2).start, axisExpression2), this.step);
            ExpressionTool.copyLocationInfo(this, pathExpression);
            return pathExpression;
        }
        return null;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        ItemType itemType2;
        Expression expression;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (this.state >= 2) {
            Expression expression2;
            Expression expression3 = this.start.typeCheck(staticContext, itemType);
            if (expression3 != this.start) {
                this.adoptChildExpression(expression3);
                this.start = expression3;
            }
            if ((expression2 = this.step.typeCheck(staticContext, this.start.getItemType(typeHierarchy))) != this.step) {
                this.adoptChildExpression(expression2);
                this.step = expression2;
            }
            return this;
        }
        this.state = 2;
        Expression expression4 = this.start.typeCheck(staticContext, itemType);
        if (expression4 != this.start) {
            this.adoptChildExpression(expression4);
            this.start = expression4;
        }
        RoleLocator roleLocator = new RoleLocator(1, "/", 0, null);
        roleLocator.setSourceLocator(this);
        roleLocator.setErrorCode("XPTY0019");
        expression4 = TypeChecker.staticTypeCheck(this.start, SequenceType.NODE_SEQUENCE, false, roleLocator, staticContext);
        if (expression4 != this.start) {
            this.adoptChildExpression(expression4);
            this.start = expression4;
        }
        if ((expression = this.step.typeCheck(staticContext, this.start.getItemType(typeHierarchy))) != this.step) {
            this.adoptChildExpression(expression);
            this.step = expression;
        }
        if (typeHierarchy.isSubType(itemType2 = this.step.getItemType(typeHierarchy), Type.NODE_TYPE)) {
            int n;
            if ((this.step.getSpecialProperties() & 0x400000) != 0) {
                PathExpression pathExpression;
                Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
                expression4 = ExpressionTool.unsorted(optimizer, this.start, false);
                if (expression4 != this.start) {
                    this.resetStaticProperties();
                    this.adoptChildExpression(expression4);
                    this.start = expression4;
                }
                if ((expression = ExpressionTool.unsorted(optimizer, this.step, false)) != this.step) {
                    this.resetStaticProperties();
                    this.adoptChildExpression(expression);
                    this.step = expression;
                }
                if ((pathExpression = this.simplifyDescendantPath(staticContext)) != null) {
                    pathExpression.setParentExpression(this.getParentExpression());
                    return pathExpression.simplify(staticContext).typeCheck(staticContext, itemType);
                }
                this.adoptChildExpression(this.start);
                this.adoptChildExpression(this.step);
            }
            if (((n = this.getSpecialProperties()) & 0x20000) != 0) {
                return this;
            }
            if ((n & 0x40000) != 0) {
                return new Reverser(this);
            }
            return new DocumentSorter(this);
        }
        if (itemType2.isAtomicType()) {
            SimpleMappingExpression simpleMappingExpression = new SimpleMappingExpression(this.start, this.step, false);
            simpleMappingExpression.setLocationId(this.getLocationId());
            simpleMappingExpression.setParentExpression(this.getParentExpression());
            return simpleMappingExpression.simplify(staticContext).typeCheck(staticContext, itemType);
        }
        SimpleMappingExpression simpleMappingExpression = new SimpleMappingExpression(this.start, this.step, true);
        simpleMappingExpression.setLocationId(this.getLocationId());
        simpleMappingExpression.setParentExpression(this.getParentExpression());
        return simpleMappingExpression.simplify(staticContext).typeCheck(staticContext, itemType);
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (this.state >= 3) {
            Expression expression2;
            Expression expression3 = this.start.optimize(optimizer, staticContext, itemType);
            if (expression3 != this.start) {
                this.adoptChildExpression(expression3);
                this.start = expression3;
            }
            if ((expression2 = this.step.optimize(optimizer, staticContext, this.start.getItemType(typeHierarchy))) != this.step) {
                this.adoptChildExpression(expression2);
                this.step = expression2;
            }
            return this;
        }
        this.state = 3;
        Expression expression4 = optimizer.convertPathExpressionToKey(this, staticContext);
        if (expression4 != null) {
            Expression.setParentExpression(expression4, this.getParentExpression());
            return expression4;
        }
        Expression expression5 = this.start.optimize(optimizer, staticContext, itemType);
        if (expression5 != this.start) {
            this.adoptChildExpression(expression5);
            this.start = expression5;
        }
        if ((expression = this.step.optimize(optimizer, staticContext, this.start.getItemType(typeHierarchy))) != this.step) {
            this.adoptChildExpression(expression);
            this.step = expression;
        }
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 10;
        promotionOffer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        promotionOffer.containingExpression = this;
        this.step = this.doPromotion(this.step, promotionOffer);
        this.resetStaticProperties();
        if (promotionOffer.containingExpression != this) {
            this.state = 0;
            promotionOffer.containingExpression = promotionOffer.containingExpression.typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
            return promotionOffer.containingExpression;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Serializable serializable;
        FilterExpression filterExpression;
        PathExpression pathExpression = this;
        if (promotionOffer.action == 11 && (filterExpression = ((Optimizer)(serializable = promotionOffer.getOptimizer())).convertToFilterExpression(this, ((Optimizer)serializable).getConfiguration().getTypeHierarchy())) != null) {
            return filterExpression.promote(promotionOffer);
        }
        serializable = promotionOffer.accept(pathExpression);
        if (serializable != null) {
            return serializable;
        }
        this.start = this.doPromotion(this.start, promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 14) {
            this.step = this.doPromotion(this.step, promotionOffer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.start, this.step);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.start == expression) {
            this.start = expression2;
            bl = true;
        }
        if (this.step == expression) {
            this.step = expression2;
            bl = true;
        }
        return bl;
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.step.getDependencies() & 0x1E1;
    }

    public int computeSpecialProperties() {
        int n = this.start.getSpecialProperties();
        int n2 = this.step.getSpecialProperties();
        int n3 = 0;
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            n |= 0xA0000;
        }
        if (!Cardinality.allowsMany(this.step.getCardinality())) {
            n2 |= 0xA0000;
        }
        if ((n & n2 & 0x10000) != 0) {
            n3 |= 0x10000;
        }
        if ((n & 0x800000) != 0 && (n2 & 0x10000) != 0) {
            n3 |= 0x800000;
        }
        if ((n & n2 & 0x80000) != 0) {
            n3 |= 0x80000;
        }
        if ((n & n2 & 0x100000) != 0) {
            n3 |= 0x100000;
        }
        if (this.testNaturallySorted(n, n2)) {
            n3 |= 0x20000;
        }
        if (this.testNaturallyReverseSorted()) {
            n3 |= 0x40000;
        }
        if ((n & n2 & 0x400000) != 0) {
            n3 |= 0x400000;
        }
        return n3;
    }

    private boolean testNaturallySorted(int n, int n2) {
        if ((n2 & 0x20000) == 0) {
            return false;
        }
        if (Cardinality.allowsMany(this.start.getCardinality())) {
            if ((n & 0x20000) == 0) {
                return false;
            }
        } else {
            return true;
        }
        if ((n2 & 0x200000) != 0) {
            return true;
        }
        return (n & 0x80000) != 0 && (n2 & 0x100000) != 0;
    }

    private boolean testNaturallyReverseSorted() {
        if (!Cardinality.allowsMany(this.start.getCardinality()) && this.step instanceof AxisExpression) {
            return !Axis.isForwards[((AxisExpression)this.step).getAxis()];
        }
        if (!(this.start instanceof AxisExpression)) {
            return false;
        }
        if (Axis.isForwards[((AxisExpression)this.start).getAxis()]) {
            return false;
        }
        return false;
    }

    public int computeCardinality() {
        int n = this.start.getCardinality();
        int n2 = this.step.getCardinality();
        return Cardinality.multiply(n, n2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PathExpression)) {
            return false;
        }
        PathExpression pathExpression = (PathExpression)object;
        return this.start.equals(pathExpression.start) && this.step.equals(pathExpression.step);
    }

    public int hashCode() {
        return "PathExpression".hashCode() + this.start.hashCode() + this.step.hashCode();
    }

    public Expression getFirstStep() {
        if (this.start instanceof PathExpression) {
            return ((PathExpression)this.start).getFirstStep();
        }
        return this.start;
    }

    public Expression getRemainingSteps() {
        if (this.start instanceof PathExpression) {
            PathExpression pathExpression = new PathExpression(((PathExpression)this.start).getRemainingSteps(), this.step);
            pathExpression.setParentExpression(this.getParentExpression());
            ExpressionTool.copyLocationInfo(this.start, pathExpression);
            return pathExpression;
        }
        return this.step;
    }

    public Expression getLastStep() {
        if (this.step instanceof PathExpression) {
            return ((PathExpression)this.step).getLastStep();
        }
        return this.step;
    }

    public Expression getLeadingSteps() {
        if (this.step instanceof PathExpression) {
            PathExpression pathExpression = new PathExpression(this.start, ((PathExpression)this.step).getLeadingSteps());
            ExpressionTool.copyLocationInfo(this.start, pathExpression);
            return pathExpression;
        }
        return this.start;
    }

    public boolean isAbsolute(TypeHierarchy typeHierarchy) {
        Expression expression = this.getFirstStep();
        return expression.getItemType(typeHierarchy).getPrimitiveType() == 9;
    }

    public PathExpression tryToMakeAbsolute(TypeHierarchy typeHierarchy) {
        Expression expression = this.getFirstStep();
        if (expression.getItemType(typeHierarchy).getPrimitiveType() == 9) {
            return this;
        }
        if (expression instanceof AxisExpression && ((AxisExpression)expression).getContextItemType().getPrimitiveType() == 9) {
            Container container = this.getParentExpression();
            PathExpression pathExpression = new PathExpression(new RootExpression(), this);
            pathExpression.setParentExpression(container);
            return pathExpression;
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.start.iterate(xPathContext);
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        xPathContextMinor.setOriginatingConstructType(2025);
        sequenceIterator = new ContextMappingIterator(this, xPathContextMinor);
        return sequenceIterator;
    }

    public SequenceIterator map(XPathContext xPathContext) throws XPathException {
        return this.step.iterate(xPathContext);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "path /");
        this.start.display(n + 1, printStream, configuration);
        this.step.display(n + 1, printStream, configuration);
    }
}

