/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;

public class GroupAdjacentIterator
implements GroupIterator,
LookaheadIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private StringCollator collator;
    private AtomicComparer comparer;
    private ComparisonKey currentComparisonKey;
    private XPathContext baseContext;
    private XPathContext runningContext;
    private AtomicValue currentKey = null;
    private List currentMembers;
    private AtomicValue nextKey = null;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupAdjacentIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext, StringCollator stringCollator) throws XPathException {
        this.population = sequenceIterator;
        this.keyExpression = expression;
        this.baseContext = xPathContext;
        this.runningContext = xPathContext.newMinorContext();
        this.runningContext.setCurrentIterator(sequenceIterator);
        this.collator = stringCollator;
        int n = expression.getItemType(xPathContext.getConfiguration().getTypeHierarchy()).getPrimitiveType();
        this.comparer = AtomicSortComparer.makeSortComparer(stringCollator, n, xPathContext);
        this.next = sequenceIterator.next();
        if (this.next != null) {
            this.nextKey = (AtomicValue)expression.evaluateItem(this.runningContext);
        }
    }

    private void advance() throws XPathException {
        Item item;
        this.currentMembers = new ArrayList(20);
        this.currentMembers.add(this.current);
        while ((item = this.population.next()) != null) {
            AtomicValue atomicValue = (AtomicValue)this.keyExpression.evaluateItem(this.runningContext);
            try {
                if (this.currentComparisonKey.equals(this.comparer.getComparisonKey(atomicValue))) {
                    this.currentMembers.add(item);
                    continue;
                }
                this.next = item;
                this.nextKey = atomicValue;
                return;
            }
            catch (ClassCastException classCastException) {
                DynamicError dynamicError = new DynamicError("Grouping key values are of non-comparable types (" + Type.displayTypeName(this.currentKey) + " and " + Type.displayTypeName(atomicValue) + ')');
                dynamicError.setIsTypeError(true);
                dynamicError.setXPathContext(this.runningContext);
                throw dynamicError;
            }
        }
        this.next = null;
        this.nextKey = null;
    }

    public AtomicValue getCurrentGroupingKey() {
        return this.currentKey;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() throws XPathException {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        this.currentKey = this.nextKey;
        this.currentComparisonKey = this.comparer.getComparisonKey(this.currentKey);
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupAdjacentIterator(this.population.getAnother(), this.keyExpression, this.baseContext, this.collator);
    }

    public int getProperties() {
        return 4;
    }
}

