/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.error;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.error.EndpointThresholds;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.Threshold;
import org.apache.uima.aae.monitor.Monitor;
import org.apache.uima.aae.monitor.statistics.LongNumericStatistic;
import org.apache.uima.aae.monitor.statistics.Statistic;
import org.apache.uima.util.Level;

public abstract class ErrorHandlerBase {
    private static final Class CLASS_NAME = ErrorHandlerBase.class;
    protected Map endpointThresholdMap;

    public ErrorHandlerBase(Map anEndpointThreasholdMap) {
        this.endpointThresholdMap = anEndpointThreasholdMap;
    }

    public ErrorHandlerBase() {
        this.endpointThresholdMap = new HashMap();
    }

    public Map getEndpointThresholdMap() {
        return this.endpointThresholdMap;
    }

    protected String getAction(String aThresholdToCheck, String endpoint) {
        Threshold threshold = this.getThreshold(aThresholdToCheck, endpoint);
        if (threshold != null) {
            return threshold.getAction();
        }
        return null;
    }

    protected String getDelegateKey(Endpoint anEndpoint, AnalysisEngineController aController) {
        String key = null;
        if (aController instanceof PrimitiveAnalysisEngineController && aController.isTopLevelComponent()) {
            key = aController.getServiceEndpointName();
        } else if (anEndpoint != null) {
            key = anEndpoint.getEndpoint();
        }
        return key;
    }

    protected boolean isValidActionForController(String anAction, AnalysisEngineController aController) {
        return !(aController instanceof PrimitiveAnalysisEngineController) || !"Disable".equalsIgnoreCase(anAction);
    }

    protected Threshold getThreshold(String aThresholdToCheck, String endpoint) {
        if (this.endpointThresholdMap.containsKey(endpoint)) {
            EndpointThresholds endpointThresholds = (EndpointThresholds)this.endpointThresholdMap.get(endpoint);
            Threshold threshold = endpointThresholds.getThreshold(aThresholdToCheck);
            return threshold;
        }
        return null;
    }

    protected boolean exceedsThreshold(String aThresholdToCheck, String endpoint, AnalysisEngineController controller) {
        Threshold threshold = this.getThreshold(aThresholdToCheck, endpoint);
        if (threshold != null) {
            Monitor monitor = controller.getMonitor();
            Statistic statistic = null;
            statistic = monitor.getStatistic(endpoint, aThresholdToCheck);
            if (statistic == null) {
                statistic = new LongNumericStatistic(aThresholdToCheck);
                monitor.addStatistic(endpoint, statistic);
            }
            if (statistic instanceof LongNumericStatistic) {
                ((LongNumericStatistic)statistic).increment();
                if (threshold.exceeded(((LongNumericStatistic)statistic).getValue())) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean exceedsThreshold(Threshold aThreshold, String aThresholdToCheck, String endpoint, AnalysisEngineController controller) {
        if (aThreshold != null) {
            Monitor monitor = controller.getMonitor();
            Statistic statistic = null;
            statistic = monitor.getStatistic(endpoint, aThresholdToCheck);
            if (statistic == null) {
                statistic = new LongNumericStatistic(aThresholdToCheck);
                monitor.addStatistic(endpoint, statistic);
            }
            if ("GetMetaErrorRetryCount".equals(aThresholdToCheck) || "ProcessErrorRetryCount".equals(aThresholdToCheck)) {
                return aThreshold.maxRetriesExceeded(((LongNumericStatistic)statistic).getValue());
            }
            return aThreshold.exceeded(((LongNumericStatistic)statistic).getValue());
        }
        return false;
    }

    protected String getEndpointName(AnalysisEngineController aController, ErrorContext anErrorContext) {
        String key = null;
        if (aController instanceof PrimitiveAnalysisEngineController) {
            key = aController.getServiceEndpointName();
        } else {
            Endpoint endpoint = (Endpoint)anErrorContext.get("Endpoint");
            key = endpoint.getEndpoint();
        }
        return key;
    }

    protected boolean isHandlerForError(ErrorContext anErrorContext, int anExpectedCommand) {
        if (anErrorContext != null) {
            int command = (Integer)anErrorContext.get("Command");
            return command == anExpectedCommand;
        }
        return false;
    }

    protected boolean shouldRetry(Threshold aThreshold, String aKindOfRetryCount, String aKey, AnalysisEngineController aController) {
        return !this.exceedsThreshold(aThreshold, aKindOfRetryCount, aKey, aController);
    }

    protected Threshold getThreshold(Endpoint anEndpoint, Map aDelegateMap, AnalysisEngineController aController) {
        String key;
        Threshold threshold = null;
        if (aController instanceof AggregateAnalysisEngineController && anEndpoint != null && aDelegateMap.containsKey(key = ((AggregateAnalysisEngineController)aController).lookUpDelegateKey(anEndpoint.getEndpoint()))) {
            threshold = (Threshold)aDelegateMap.get(key);
        }
        return threshold;
    }

    protected synchronized void incrementStatistic(Monitor aMonitor, String aComponentName, String aStatistic) {
        Statistic statistic = aMonitor.getStatistic(aComponentName, aStatistic);
        if (statistic == null) {
            statistic = new LongNumericStatistic(aStatistic);
            aMonitor.addStatistic(aComponentName, statistic);
        }
        if (statistic instanceof LongNumericStatistic) {
            ((LongNumericStatistic)statistic).increment();
        }
    }

    protected boolean retryLastCommand(int aRetryCommand, Endpoint anEndpoint, AnalysisEngineController aController, String aKey, Threshold aThreshold, ErrorContext anErrorContext) {
        boolean done = false;
        if (aController == null) {
            return false;
        }
        String errorCounterKind = aRetryCommand == 2001 ? "GetMetaErrorRetryCount" : "ProcessErrorRetryCount";
        boolean retryCount = false;
        while (!done) {
            if (this.shouldRetry(aThreshold, errorCounterKind, aKey, aController)) {
                this.incrementStatistic(aController.getMonitor(), aKey, errorCounterKind);
                try {
                    switch (aRetryCommand) {
                        case 2001: {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "retryLastCommand", "uimaee_messages", "UIMAEE_retrying_getmeta__INFO", new Object[]{aController.getComponentName(), anEndpoint.getDelegateKey()});
                            }
                            ((AggregateAnalysisEngineController)aController).retryMetadataRequest(anEndpoint);
                            break;
                        }
                        case 2000: {
                            if (anErrorContext.containsKey("Endpoint")) {
                                Endpoint masterEndpoint = (Endpoint)anErrorContext.get("Endpoint");
                                if (aController instanceof AggregateAnalysisEngineController && masterEndpoint != null && masterEndpoint.getStatus() == 2) {
                                    InputChannel iC = aController.getReplyInputChannel(masterEndpoint.getDelegateKey());
                                    iC.createListener(masterEndpoint.getDelegateKey(), null);
                                    iC.removeDelegateFromFailedList(masterEndpoint.getDelegateKey());
                                    anEndpoint.setDestination(masterEndpoint.getDestination());
                                }
                            }
                            String casReferenceId = (String)anErrorContext.get("CasReference");
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "retryLastCommand", "uimaee_messages", "UIMAEE_retrying_process_cas__INFO", new Object[]{aController.getComponentName(), casReferenceId, anEndpoint.getDelegateKey()});
                            }
                            ((AggregateAnalysisEngineController)aController).retryProcessCASRequest(casReferenceId, anEndpoint, true);
                        }
                    }
                    return true;
                }
                catch (Exception e) {
                    anEndpoint.cancelTimer();
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "retryLastCommand", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "retryLastCommand", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                    continue;
                }
            }
            done = true;
        }
        return false;
    }

    protected synchronized boolean exceedsThresholdWithinWindow(Monitor aMonitor, String aStat, String aComponent, Threshold aThreshold) {
        LongNumericStatistic currentErrorCountStat = aMonitor.getLongNumericStatistic(aComponent, aStat);
        LongNumericStatistic currentProcessCountStat = aMonitor.getLongNumericStatistic(aComponent, "ProcessCount");
        long numberOfErrors = currentErrorCountStat.getValue();
        if (numberOfErrors > 0L && aThreshold.getThreshold() > 0L && numberOfErrors % aThreshold.getThreshold() == 0L) {
            return true;
        }
        if (aThreshold.getThreshold() > 0L && aThreshold.getWindow() > 0L && currentProcessCountStat.getValue() % aThreshold.getWindow() == 0L) {
            aMonitor.resetCountingStatistic(aComponent, aStat);
        }
        return false;
    }

    protected boolean continueOnError(String aDelegateKey, Threshold aThreshold, String aCasReferenceId, Throwable t, AnalysisEngineController aController) {
        block4: {
            try {
                if (aThreshold.getContinueOnRetryFailure() && ((AggregateAnalysisEngineController)aController).continueOnError(aCasReferenceId, aDelegateKey, (Exception)t)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (aController != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "continueOnError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                }
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "continueOnError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        return false;
    }
}

