/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.CasEditorError;
import org.eclipse.core.runtime.IAdaptable;

public class ArrayValue
implements IAdaptable {
    private final FeatureStructure arrayFS;
    private final int slot;

    public ArrayValue(FeatureStructure arrayFS, int slot) {
        if (!arrayFS.getType().isArray()) {
            throw new IllegalArgumentException("The arrayFS parameter must contain an array type FS!");
        }
        this.arrayFS = arrayFS;
        this.slot = slot;
    }

    public FeatureStructure getFeatureStructure() {
        return this.arrayFS;
    }

    public int slot() {
        return this.slot;
    }

    public void set(String value) {
        if (this.arrayFS instanceof BooleanArrayFS) {
            BooleanArrayFS array = (BooleanArrayFS)this.arrayFS;
            array.set(this.slot, Boolean.parseBoolean(value));
        } else if (this.arrayFS instanceof ByteArrayFS) {
            ByteArrayFS array = (ByteArrayFS)this.arrayFS;
            array.set(this.slot, Byte.parseByte(value));
        } else if (this.arrayFS instanceof ShortArrayFS) {
            ShortArrayFS array = (ShortArrayFS)this.arrayFS;
            array.set(this.slot, Short.parseShort(value));
        } else if (this.arrayFS instanceof IntArrayFS) {
            IntArrayFS array = (IntArrayFS)this.arrayFS;
            array.set(this.slot, Integer.parseInt(value));
        } else if (this.arrayFS instanceof LongArrayFS) {
            LongArrayFS array = (LongArrayFS)this.arrayFS;
            array.set(this.slot, Long.parseLong(value));
        } else if (this.arrayFS instanceof FloatArrayFS) {
            FloatArrayFS array = (FloatArrayFS)this.arrayFS;
            array.set(this.slot, Float.parseFloat(value));
        } else if (this.arrayFS instanceof DoubleArrayFS) {
            DoubleArrayFS array = (DoubleArrayFS)this.arrayFS;
            array.set(this.slot, Double.parseDouble(value));
        } else if (this.arrayFS instanceof StringArrayFS) {
            StringArrayFS array = (StringArrayFS)this.arrayFS;
            array.set(this.slot, value);
        } else {
            throw new CasEditorError("Unknown array type!");
        }
    }

    public Object get() {
        if (this.arrayFS instanceof BooleanArrayFS) {
            BooleanArrayFS array = (BooleanArrayFS)this.arrayFS;
            return array.get(this.slot);
        }
        if (this.arrayFS instanceof ByteArrayFS) {
            ByteArrayFS array = (ByteArrayFS)this.arrayFS;
            return array.get(this.slot);
        }
        if (this.arrayFS instanceof ShortArrayFS) {
            ShortArrayFS array = (ShortArrayFS)this.arrayFS;
            return array.get(this.slot);
        }
        if (this.arrayFS instanceof IntArrayFS) {
            IntArrayFS array = (IntArrayFS)this.arrayFS;
            return array.get(this.slot);
        }
        if (this.arrayFS instanceof LongArrayFS) {
            LongArrayFS array = (LongArrayFS)this.arrayFS;
            return array.get(this.slot);
        }
        if (this.arrayFS instanceof FloatArrayFS) {
            FloatArrayFS array = (FloatArrayFS)this.arrayFS;
            return Float.valueOf(array.get(this.slot));
        }
        if (this.arrayFS instanceof DoubleArrayFS) {
            DoubleArrayFS array = (DoubleArrayFS)this.arrayFS;
            return array.get(this.slot);
        }
        if (this.arrayFS instanceof StringArrayFS) {
            StringArrayFS array = (StringArrayFS)this.arrayFS;
            String value = array.get(this.slot);
            if (value == null) {
                value = "";
            }
            return value;
        }
        if (this.arrayFS instanceof ArrayFS) {
            ArrayFS array = (ArrayFS)this.arrayFS;
            return array.get(this.slot);
        }
        throw new CasEditorError("Unknown array type!");
    }

    public Object getAdapter(Class adapter) {
        FeatureStructure fs;
        if (FeatureStructure.class.equals((Object)adapter) && this.arrayFS instanceof ArrayFS) {
            ArrayFS array = (ArrayFS)this.arrayFS;
            return array.get(this.slot());
        }
        if (AnnotationFS.class.equals((Object)adapter) && (fs = (FeatureStructure)this.getAdapter(FeatureStructure.class)) instanceof AnnotationFS) {
            return fs;
        }
        return null;
    }

    public String toString() {
        return Integer.toString(this.slot());
    }
}

