/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FsIndex_set_sorted;
import org.apache.uima.cas.impl.FsIndex_singletype;
import org.apache.uima.cas.impl.FsIndex_snapshot;
import org.apache.uima.cas.impl.FsIterator_aggregation_common;
import org.apache.uima.cas.impl.FsIterator_subtypes_ordered;
import org.apache.uima.cas.impl.LLUnambiguousIteratorImpl;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.cas.TOP;

class FsIndex_iicp<T extends FeatureStructure>
extends AbstractCollection<T>
implements Comparable<FsIndex_iicp<? extends FeatureStructure>>,
Comparator<FeatureStructure>,
LowLevelIndex<T> {
    final FSIndexRepositoryImpl fsIndexRepositoryImpl;
    final FsIndex_singletype<T> fsIndex_singletype;
    FsIndex_singletype<TOP>[] cachedSubFsLeafIndexes = null;
    private volatile boolean isIteratorCacheSetup = false;
    int[] sortedTypeCodes;

    FsIndex_iicp(FsIndex_singletype<T> fsIndex_singletype) {
        this.fsIndex_singletype = fsIndex_singletype;
        this.fsIndexRepositoryImpl = fsIndex_singletype.casImpl.indexRepository;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(", index=");
        sb.append(this.fsIndex_singletype).append('\n');
        if (!this.isIteratorCacheSetup) {
            sb.append(" cache not set up yet");
        } else {
            int len = Math.min(3, this.cachedSubFsLeafIndexes.length);
            for (int i = 0; i < len; ++i) {
                FsIndex_singletype<TOP> lii = this.cachedSubFsLeafIndexes[i];
                sb.append("  cache ").append(i++);
                sb.append("  ").append(lii).append('\n');
            }
            if (this.cachedSubFsLeafIndexes.length > 3) {
                sb.append(" ... and " + (this.cachedSubFsLeafIndexes.length - 3) + " more\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FsIndex_iicp)) {
            return false;
        }
        FsIndex_iicp iicp = (FsIndex_iicp)o;
        return this.getIndexingStrategy() == iicp.getIndexingStrategy() && this.fsIndex_singletype.getComparatorImplForIndexSpecs().equals(iicp.fsIndex_singletype.getComparatorImplForIndexSpecs());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fsIndex_singletype.getComparatorImplForIndexSpecs().hashCode();
        result = 31 * result + this.getIndexingStrategy();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createIndexIteratorCache() {
        if (this.isIteratorCacheSetup) {
            return;
        }
        FsIndex_iicp fsIndex_iicp = this;
        synchronized (fsIndex_iicp) {
            if (this.isIteratorCacheSetup) {
                return;
            }
            TypeImpl rootType = (TypeImpl)this.fsIndex_singletype.getComparatorImplForIndexSpecs().getType();
            int indexKind = this.getIndexingStrategy();
            int size = indexKind == 3 ? 1 : 1 + (int)rootType.getAllSubtypes().count();
            ArrayList<FsIndex_singletype<FeatureStructure>> tempSubIndexCache = new ArrayList<FsIndex_singletype<FeatureStructure>>();
            this.sortedTypeCodes = indexKind == 0 ? new int[size] : null;
            this.initOneTypeThenAllSubtypes(rootType, tempSubIndexCache, indexKind);
            this.cachedSubFsLeafIndexes = tempSubIndexCache.toArray(new FsIndex_singletype[tempSubIndexCache.size()]);
            if (this.getIndexingStrategy() == 0) {
                Arrays.sort(this.sortedTypeCodes);
            }
            this.isIteratorCacheSetup = true;
        }
    }

    private void initOneTypeThenAllSubtypes(TypeImpl ti, ArrayList<FsIndex_singletype<FeatureStructure>> cache, int indexKind) {
        FsIndex_singletype<T> singleIndex = this.fsIndexRepositoryImpl.getIndexBySpec((int)ti.getCode(), (int)this.getIndexingStrategy(), (FSIndexComparatorImpl)this.getComparatorImplForIndexSpecs()).fsIndex_singletype;
        if (indexKind == 0) {
            this.sortedTypeCodes[cache.size()] = singleIndex.getTypeCode();
        }
        cache.add(singleIndex);
        if (indexKind != 3) {
            for (TypeImpl subti : ti.getDirectSubtypes()) {
                this.initOneTypeThenAllSubtypes(subti, cache, indexKind);
            }
        }
    }

    @Override
    public int compareTo(FsIndex_iicp<? extends FeatureStructure> cp) {
        int typeCode2;
        int typeCode1 = ((TypeImpl)this.fsIndex_singletype.getType()).getCode();
        if (typeCode1 < (typeCode2 = ((TypeImpl)cp.fsIndex_singletype.getType()).getCode())) {
            return -1;
        }
        if (typeCode1 > typeCode2) {
            return 1;
        }
        return this.fsIndex_singletype.getComparatorImplForIndexSpecs().compareTo(cp.fsIndex_singletype.getComparatorImplForIndexSpecs());
    }

    @Override
    public int size() {
        this.createIndexIteratorCache();
        int size = 0;
        for (FsIndex_singletype<TOP> iicp : this.cachedSubFsLeafIndexes) {
            size += iicp.size();
        }
        return size;
    }

    @Override
    public int ll_maxAnnotSpan() {
        this.createIndexIteratorCache();
        int span = -1;
        FsIndex_singletype<T> idx = this.getFsIndex_singleType();
        if (idx instanceof FsIndex_set_sorted && ((FsIndex_set_sorted)idx).isAnnotIdx) {
            for (FsIndex_singletype<TOP> subIndex : this.cachedSubFsLeafIndexes) {
                int s = ((FsIndex_set_sorted)subIndex).ll_maxAnnotSpan();
                if (s <= span) continue;
                span = s;
            }
        }
        return span == -1 ? Integer.MAX_VALUE : span;
    }

    @Override
    public boolean isEmpty() {
        this.createIndexIteratorCache();
        for (FsIndex_singletype<TOP> index : this.cachedSubFsLeafIndexes) {
            if (index.size() <= 0) continue;
            return false;
        }
        return true;
    }

    int guessedSize() {
        FsIndex_singletype<TOP>[] localIc = this.cachedSubFsLeafIndexes;
        int len = localIc.length;
        int lim = Math.min(3, len);
        int size = 0;
        for (int i = 0; i < lim; ++i) {
            size += localIc[i].size();
        }
        return size += len - lim;
    }

    FsIndex_singletype<T> getFsIndex_singleType() {
        return this.fsIndex_singletype;
    }

    boolean isDefaultBagIndex() {
        return this.getIndexingStrategy() == 3;
    }

    boolean isSetIndex() {
        return this.getIndexingStrategy() == 1;
    }

    @Override
    public int ll_compare(int ref1, int ref2) {
        return this.fsIndex_singletype.ll_compare(ref1, ref2);
    }

    @Override
    public int getIndexingStrategy() {
        return this.fsIndex_singletype.getIndexingStrategy();
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.fsIndex_singletype.comparatorWithoutID;
    }

    @Override
    public FSIndexComparator getComparatorForIndexSpecs() {
        return this.fsIndex_singletype.getComparatorForIndexSpecs();
    }

    public FSIndexComparatorImpl getComparatorImplForIndexSpecs() {
        return this.fsIndex_singletype.getComparatorImplForIndexSpecs();
    }

    @Override
    public int compare(FeatureStructure fs1, FeatureStructure fs2) {
        return this.fsIndex_singletype.comparatorWithoutID.compare((TOP)fs1, (TOP)fs2);
    }

    @Override
    public boolean contains(FeatureStructure fs) {
        return this.find(fs) != null;
    }

    @Override
    public T find(FeatureStructure fs) {
        this.createIndexIteratorCache();
        for (FsIndex_singletype<TOP> idx : this.cachedSubFsLeafIndexes) {
            Object result = idx.find(fs);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Type getType() {
        return this.fsIndex_singletype.getType();
    }

    int getTypeCode() {
        return this.fsIndex_singletype.getTypeCode();
    }

    @Override
    public CASImpl getCasImpl() {
        return this.fsIndex_singletype.casImpl;
    }

    @Override
    public boolean isSorted() {
        return this.fsIndex_singletype.isSorted();
    }

    @Override
    public LowLevelIterator<T> iterator() {
        return this.iterator(false, false);
    }

    @Override
    public LowLevelIterator<T> iterator(boolean orderNotNeeded, boolean ignoreType) {
        Comparator<TOP> comparatorMaybeNoTypeWithoutId;
        this.createIndexIteratorCache();
        if (this.cachedSubFsLeafIndexes.length == 1) {
            return this.fsIndex_singletype.iterator(false, ignoreType);
        }
        FsIndex_singletype<T> idx = this.getFsIndex_singleType();
        Comparator<TOP> comparator = comparatorMaybeNoTypeWithoutId = ignoreType ? idx.comparatorNoTypeWithoutID : idx.comparatorWithoutID;
        if (!this.fsIndex_singletype.isSorted() || orderNotNeeded) {
            return new FsIterator_aggregation_common<T>(this.getIterators(), this, comparatorMaybeNoTypeWithoutId);
        }
        return new FsIterator_subtypes_ordered(this, comparatorMaybeNoTypeWithoutId);
    }

    @Override
    public LowLevelIterator<T> ll_iterator(boolean ambiguous) {
        LLUnambiguousIteratorImpl it = this.iterator(false, false);
        return ambiguous ? it : new LLUnambiguousIteratorImpl(it);
    }

    @Override
    public FSIndex<T> withSnapshotIterators() {
        FsIndex_singletype<T> idx = this.getFsIndex_singleType();
        return new FsIndex_snapshot(this, idx.comparatorWithoutID, idx.comparatorNoTypeWithoutID);
    }

    public FSIndexRepositoryImpl getFsRepositoryImpl() {
        return this.getCasImpl().indexRepository;
    }

    public Stream<FsIndex_singletype<TOP>> streamNonEmptyIndexes() {
        this.createIndexIteratorCache();
        return Arrays.stream(this.cachedSubFsLeafIndexes).filter(idx -> idx.size() > 0);
    }

    void collectCowIndexParts(ArrayList<CopyOnWriteIndexPart<T>> indexes) {
        this.createIndexIteratorCache();
        for (FsIndex_singletype<TOP> idx : this.cachedSubFsLeafIndexes) {
            if (idx.size() <= 0) continue;
            indexes.add(idx.getNonNullCow());
        }
    }

    LowLevelIterator<T>[] getIterators() {
        this.createIndexIteratorCache();
        LowLevelIterator[] r = new LowLevelIterator[this.cachedSubFsLeafIndexes.length];
        int i = 0;
        for (FsIndex_singletype<TOP> idx : this.cachedSubFsLeafIndexes) {
            r[i++] = idx.iterator();
        }
        return r;
    }
}

