/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

public class TimeSpan {
    private long all;
    private int years;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;
    private boolean knowsFull = false;
    private boolean knowsMS = false;
    private static final long msSecond = 1000L;
    private static final long msMinute = 60000L;
    private static final long msHour = 3600000L;
    private static final long msDay = 86400000L;
    private static final long msYear = 31536000000L;
    private static final String yearsString = "yrs";
    private static final String daysString = "days";
    private static final String hoursString = "hrs";
    private static final String minutesString = "min";
    private static final String secondsString = "sec";
    private static final String msString = "ms";
    private static final String unknownTime = "unknown";

    public TimeSpan() {
    }

    public TimeSpan(long milliseconds) {
        if (milliseconds >= 0L) {
            this.all = milliseconds;
            this.knowsMS = true;
        }
    }

    public boolean isInstantiated() {
        return this.knowsMS || this.knowsFull;
    }

    public boolean setYears(int years) {
        if (years < 0) {
            return false;
        }
        this.years = years;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setDays(int days) {
        if (days < 0) {
            return false;
        }
        this.days = days;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setHours(int hours) {
        if (hours < 0) {
            return false;
        }
        this.hours = hours;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setMinutes(int minutes) {
        if (minutes < 0) {
            return false;
        }
        this.minutes = minutes;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setSeconds(int seconds) {
        if (seconds < 0) {
            return false;
        }
        this.seconds = seconds;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setMilliseconds(int milliseconds) {
        if (milliseconds < 0) {
            return false;
        }
        this.milliseconds = milliseconds;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setFullMilliseconds(long milliseconds) {
        if (milliseconds < 0L) {
            return false;
        }
        this.all = milliseconds;
        this.knowsMS = true;
        this.knowsFull = false;
        return true;
    }

    public long getFullMilliseconds() {
        this.ensureAll();
        if (!this.knowsMS) {
            return -1L;
        }
        return this.all;
    }

    public int getYears() {
        this.ensureFull();
        return this.isInstantiated() ? this.years : -1;
    }

    public int getDays() {
        this.ensureFull();
        return this.isInstantiated() ? this.days : -1;
    }

    public int getHours() {
        this.ensureFull();
        return this.isInstantiated() ? this.hours : -1;
    }

    public int getMinutes() {
        this.ensureFull();
        return this.isInstantiated() ? this.minutes : -1;
    }

    public int getSeconds() {
        this.ensureFull();
        return this.isInstantiated() ? this.seconds : -1;
    }

    public int getMilliseconds() {
        this.ensureFull();
        return this.isInstantiated() ? this.milliseconds : -1;
    }

    public String toString() {
        this.ensureFull();
        if (!this.knowsFull) {
            return unknownTime;
        }
        StringBuffer buf = new StringBuffer();
        boolean started = false;
        if (this.years > 0) {
            buf.append(this.years);
            buf.append(' ');
            buf.append(yearsString);
            started = true;
        }
        if (started || this.days > 0) {
            if (started) {
                buf.append(' ');
            }
            buf.append(this.days);
            buf.append(' ');
            buf.append(daysString);
            started = true;
        }
        if (started || this.hours > 0) {
            if (started) {
                buf.append(' ');
            }
            buf.append(this.hours);
            buf.append(' ');
            buf.append(hoursString);
            started = true;
        }
        if (started || this.minutes > 0) {
            if (started) {
                buf.append(' ');
            }
            buf.append(this.minutes);
            buf.append(' ');
            buf.append(minutesString);
            started = true;
        }
        if (started || this.seconds > 0) {
            if (started) {
                buf.append(' ');
            }
            buf.append(this.seconds);
            started = true;
        }
        if (started) {
            buf.append('.');
            if (this.milliseconds < 100) {
                buf.append('0');
                if (this.milliseconds < 10) {
                    buf.append('0');
                }
            }
            buf.append(this.milliseconds);
            buf.append(' ');
            buf.append(secondsString);
        } else {
            buf.append(this.milliseconds);
            buf.append(' ');
            buf.append(msString);
        }
        return buf.toString();
    }

    private void ensureAll() {
        if (this.knowsMS || !this.knowsFull) {
            return;
        }
        this.all = 0L;
        this.all += (long)this.years * 31536000000L;
        this.all += (long)this.days * 86400000L;
        this.all += (long)this.hours * 3600000L;
        this.all += (long)this.minutes * 60000L;
        this.all += (long)this.seconds * 1000L;
        this.all += (long)this.milliseconds;
        this.knowsMS = true;
    }

    private void ensureFull() {
        if (this.knowsFull || !this.knowsMS) {
            return;
        }
        long t = this.all;
        this.years = (int)(t / 31536000000L);
        this.days = (int)((t %= 31536000000L) / 86400000L);
        this.hours = (int)((t %= 86400000L) / 3600000L);
        this.minutes = (int)((t %= 3600000L) / 60000L);
        this.seconds = (int)((t %= 60000L) / 1000L);
        this.milliseconds = (int)(t %= 1000L);
        this.knowsFull = true;
    }
}

