/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.Collection;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractIdentityResourceLoader;

public abstract class AbstractKeyEntryResolver<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractIdentityResourceLoader<PUB, PRV>
implements KeyEntryResolver<PUB, PRV> {
    protected AbstractKeyEntryResolver(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names) {
        super(pubType, prvType, names);
    }

    public PUB generatePublicKey(KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactoryInstance();
        Class keyType = this.getPublicKeyType();
        return (PUB)((PublicKey)keyType.cast(factory.generatePublic(keySpec)));
    }

    public PRV generatePrivateKey(KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactoryInstance();
        Class keyType = this.getPrivateKeyType();
        return (PRV)((PrivateKey)keyType.cast(factory.generatePrivate(keySpec)));
    }

    public String toString() {
        return this.getPublicKeyType().getSimpleName() + ": " + this.getSupportedTypeNames();
    }
}

