var hdg = props.globals.getNode("orientation/heading-magnetic-deg");
var hdgBug = props.globals.getNode("autopilot/settings/heading-bug-deg");
var lon = props.globals.getNode("position/longitude-deg");
var lat = props.globals.getNode("position/latitude-deg");
var index = 0;

var instrument_path = "Aircraft/AlphaElectro/Models/Instruments/Aera660/";

var aera660_controller = {
	parents: [canvas.Map.Controller],

	new: func(map) {
		var m = { parents: [aera660_controller],
			map: map,
			};
		m.index = index;

		return m;
	}
};

var canvas_nd = {
	new: func(canvasGroup)
	{
		var m = { parents: [canvas_nd] };
		m.group = canvasGroup;
		m.map = canvasGroup.createChild('map');
		m.index = index;

		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		canvas.parsesvg(canvasGroup, instrument_path~"aera660.map.svg", {'font-mapper': font_mapper});

		var svg_keys = [];
		foreach(var key; svg_keys) {
			m[key] = canvasGroup.getElementById(key);
			var clip_el = canvasGroup.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)",
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				m[key].set("clip", clip_rect);
				m[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		### NavDisplay ###
		m.map.setRange( 25 * 300 / 520 );
		m.on_range_change();
		m.map.setTranslation(400, 240); # AC center
		m.map.setPos(lat.getValue(),lon.getValue(), 0.0);
		var r = func(name,vis=1,zindex=nil) return caller(0)[0];
		m.map.setController(aera660_controller);

		foreach(var type; [ r('STAMEN') ])
				m.map.addLayer(factory: canvas.OverlayLayer, type_arg: type.name,visible: type.vis, priority: type.zindex,);

		foreach(var type; [r('TFC'),r('APT') ] )
				m.map.addLayer(factory: canvas.SymbolLayer, type_arg: type.name, visible: type.vis, priority: type.zindex,);

		index+=1;

		m.timer = maketimer(0.2, m, m.update);
		return m;
	},
	update: func()
	{
		
		me.map.setPos(lat.getValue(), lon.getValue(), 0.0);
		me.map.setRotation( -hdg.getDoubleValue() * D2R, [ 240, 374 ] );
		me.map.update();
	},
	on_range_change: func {
	},
	show: func()
	{
		me.update();
		me.timer.start();
		me.group.show();
	},
	hide: func()
	{
		me.timer.stop();
		me.group.hide();
	}
};
