/*
 * Copyright (C) 2014-2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <Foundation/Foundation.h>
#import <WebKit/WKFoundation.h>

NS_ASSUME_NONNULL_BEGIN

WK_EXTERN API_AVAILABLE(macos(10.10), ios(8.0))
@interface _WKProcessPoolConfiguration : NSObject <NSCopying>

@property (nonatomic, copy) NSURL *injectedBundleURL;
@property (nonatomic, copy) NSSet<Class> *customClassesForParameterCoder API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) NSUInteger maximumProcessCount API_DEPRECATED("It is no longer possible to limit the number of processes", macos(10.0, 10.15), ios(1.0, 13.0));
@property (nonatomic) BOOL usesSingleWebProcess API_AVAILABLE(macos(10.15), ios(13.0));
@property (nonatomic, nullable, copy) NSString *customWebContentServiceBundleIdentifier API_AVAILABLE(macos(10.14.4), ios(12.2));

@property (nonatomic) BOOL ignoreSynchronousMessagingTimeoutsForTesting API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic) BOOL attrStyleEnabled API_AVAILABLE(macos(10.14.4), ios(12.2));

// Defaults to YES.
@property (nonatomic) BOOL shouldThrowExceptionForGlobalConstantRedeclaration API_AVAILABLE(macos(12.0), ios(15.0));

@property (nonatomic, copy) NSArray<NSURL *> *additionalReadAccessAllowedURLs API_AVAILABLE(macos(10.13), ios(11.0));

#if TARGET_OS_IPHONE && !TARGET_OS_SIMULATOR
@property (nonatomic) NSUInteger wirelessContextIdentifier API_DEPRECATED("Use of this API is no longer necessary and can be removed", ios(10.12, 13.0));
#endif

// Network Process properties
// FIXME: These should be be per-session/data store when we support multiple non-persistent sessions/data stores.

@property (nonatomic) NSInteger diskCacheSizeOverride API_DEPRECATED("Use [WKWebsiteDataStore nonPersistentDataStore] to limit disk cache size to 0", macos(10.11, 10.14.4), ios(9.0, 12.2));
@property (nonatomic, copy) NSArray *cachePartitionedURLSchemes;
@property (nonatomic, copy) NSArray<NSString *> *alwaysRevalidatedURLSchemes API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic) BOOL diskCacheSpeculativeValidationEnabled API_DEPRECATED_WITH_REPLACEMENT("_WKWebsiteDataStoreConfiguration.networkCacheSpeculativeValidationEnabled", macos(10.12, 10.15.4), ios(10.0, 13.4));
@property (nonatomic, nullable, copy) NSString *sourceApplicationBundleIdentifier API_DEPRECATED_WITH_REPLACEMENT("_WKWebsiteDataStoreConfiguration.sourceApplicationBundleIdentifier", macos(10.12.3, 10.14.4), ios(10.3, 12.2));
@property (nonatomic, nullable, copy) NSString *sourceApplicationSecondaryIdentifier API_DEPRECATED_WITH_REPLACEMENT("_WKWebsiteDataStoreConfiguration.sourceApplicationSecondaryIdentifier", macos(10.12.3, 10.14.4), ios(10.3, 12.2));
@property (nonatomic) BOOL shouldCaptureAudioInUIProcess API_AVAILABLE(macos(10.13), ios(11.0));
#if TARGET_OS_IPHONE
@property (nonatomic) BOOL alwaysRunsAtBackgroundPriority API_AVAILABLE(ios(10.3));
@property (nonatomic) BOOL shouldTakeUIBackgroundAssertion API_AVAILABLE(ios(11.0));
#endif
@property (nonatomic) pid_t presentingApplicationPID API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic) audit_token_t presentingApplicationProcessToken API_AVAILABLE(macos(10.13), ios(11.3));
@property (nonatomic) BOOL processSwapsOnNavigation API_AVAILABLE(macos(10.14), ios(12.0));
@property (nonatomic) BOOL forceOverlayScrollbars API_AVAILABLE(macos(10.14));
@property (nonatomic) BOOL alwaysKeepAndReuseSwappedProcesses API_AVAILABLE(macos(10.14), ios(12.0));
@property (nonatomic) BOOL processSwapsOnWindowOpenWithOpener API_AVAILABLE(macos(10.14), ios(12.0));
@property (nonatomic) BOOL processSwapsOnNavigationWithinSameNonHTTPFamilyProtocol API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic) BOOL prewarmsProcessesAutomatically API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic) BOOL usesWebProcessCache API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic) BOOL pageCacheEnabled API_AVAILABLE(macos(10.14), ios(12.0));
@property (nonatomic, getter=isJITEnabled) BOOL JITEnabled API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, nullable, copy, setter=setHSTSStorageDirectory:) NSURL *hstsStorageDirectory API_DEPRECATED_WITH_REPLACEMENT("_WKWebsiteDataStoreConfiguration.hstsStorageDirectory", macos(10.15, 12.0), ios(13.0, 15.0));

@property (nonatomic) BOOL configureJSCForTesting API_AVAILABLE(macos(10.15.4), ios(13.4));

@end

NS_ASSUME_NONNULL_END
