/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "EventTargetInlines.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "Node.h"
#include <JavaScriptCore/DOMJITGetterSetter.h>
#include <JavaScriptCore/Snippet.h>
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSNode : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = Node;
    static JSNode* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<Node>&& impl)
    {
        SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject->vm();
        JSNode* ptr = new (NotNull, JSC::allocateCell<JSNode>(vm)) JSNode(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static Node* toWrapped(JSC::VM&, JSC::JSValue);

protected:
    static const JSC::ClassInfo s_info;
public:
    static constexpr const JSC::ClassInfo* info() { return &s_info; }

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSNodeType), StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    DECLARE_VISIT_CHILDREN;
    template<typename Visitor> void visitAdditionalChildren(Visitor&);

    template<typename Visitor> static void visitOutputConstraints(JSCell*, Visitor&);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom attributes
    JSC::JSValue nodeType(JSC::JSGlobalObject&) const;
    Node& wrapped() const
    {
        return static_cast<Node&>(Base::wrapped());
    }

    Ref<Node> protectedWrapped() const;

protected:
    JSNode(JSC::Structure*, JSDOMGlobalObject&, Ref<Node>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class WEBCORE_EXPORT JSNodeOwner : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, ASCIILiteral*) override;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) override;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, Node*)
{
    static NeverDestroyed<JSNodeOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(Node* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, Node&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Node* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<Node>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<Node>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

#if ENABLE(JIT)
Ref<JSC::Snippet> checkSubClassSnippetForJSNode();
#endif
// DOM JIT Attributes

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileNodeNodeTypeAttribute();
#endif

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileNodeOwnerDocumentAttribute();
#endif

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileNodeParentNodeAttribute();
#endif

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileNodeFirstChildAttribute();
#endif

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileNodeLastChildAttribute();
#endif

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileNodePreviousSiblingAttribute();
#endif

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileNodeNextSiblingAttribute();
#endif

template<> struct JSDOMWrapperConverterTraits<Node> {
    using WrapperClass = JSNode;
    using ToWrappedReturnType = Node*;
};
template<> ConversionResult<IDLDictionary<Node::GetRootNodeOptions>> convertDictionary<Node::GetRootNodeOptions>(JSC::JSGlobalObject&, JSC::JSValue);


} // namespace WebCore
#include "JSNodeCustom.h"
